/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.model.gantt;

import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.gantt.ITimelineObject;
import java.util.Iterator;
import java.util.List;

public class BinarySearchTimelineObjectIterator<T extends ITimelineObject>
implements Iterator<T> {
    private List<T> objectList;
    private int index = -1;
    private ITimeSpan span;

    public BinarySearchTimelineObjectIterator(List<T> objectList, ITimeSpan span) {
        if (span == null) {
            throw new IllegalArgumentException("time span can not be NULL");
        }
        this.objectList = objectList;
        this.span = span;
        this.index = this.findFirstObject();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        if (this.objectList.size() > this.index) {
            ITimelineObject obj = (ITimelineObject)this.objectList.get(this.index);
            return obj.getTimeSpan().getStartTime() <= this.span.getEndTime();
        }
        return false;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            return (T)((ITimelineObject)this.objectList.get(this.index++));
        }
        throw new UnsupportedOperationException("iterator has no more elements to return");
    }

    private int findFirstObject() {
        int m = 0;
        int result = 0;
        if (this.objectList != null && this.objectList.size() > 0) {
            long startTime = this.span.getStartTime();
            long endTime = this.span.getEndTime();
            int low = 0;
            int high = this.objectList.size() - 1;
            do {
                m = low + (high - low) / 2;
                ITimelineObject obj = (ITimelineObject)this.objectList.get(m);
                ITimeSpan entrySpan = obj.getTimeSpan();
                long su = entrySpan.getStartTime();
                long eu = entrySpan.getEndTime();
                if (eu >= startTime && su <= endTime) {
                    high = m - 1;
                    continue;
                }
                if (eu < startTime) {
                    low = m + 1;
                    continue;
                }
                if (su <= endTime) continue;
                high = m - 1;
            } while (high >= low);
            result = low;
            if (low > 0) {
                ITimelineObject obj;
                ITimeSpan s;
                int i = low = Math.min(low, this.objectList.size() - 1);
                while (low >= 0 && (s = (obj = (ITimelineObject)this.objectList.get(i)).getTimeSpan()).intersects(this.span)) {
                    result = i;
                    --low;
                }
            }
        }
        return result;
    }
}

