/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.model.eventline;

import com.dlsc.flexgantt.model.eventline.EventlineSelectionModelEvent;
import com.dlsc.flexgantt.model.eventline.IEventlineSelectionListener;
import com.dlsc.flexgantt.model.eventline.IEventlineSelectionModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.EventListenerList;

public class DefaultEventlineSelectionModel
implements IEventlineSelectionModel {
    private List<Object> selections = new ArrayList<Object>();
    private EventListenerList listenerList = new EventListenerList();
    private IEventlineSelectionModel.Mode mode = IEventlineSelectionModel.Mode.MULTIPLE_SELECTION;

    @Override
    public void addSelection(Object eventlineObject) {
        if (eventlineObject == null) {
            throw new IllegalArgumentException("eventline object can not be NULL");
        }
        if (this.mode.equals((Object)IEventlineSelectionModel.Mode.SINGLE_SELECTION)) {
            this.selections.clear();
        }
        this.selections.add(eventlineObject);
        this.fireSelectionModelEvent(new EventlineSelectionModelEvent((IEventlineSelectionModel)this, EventlineSelectionModelEvent.ID.EVENTLINE_OBJECTS_ADDED, eventlineObject));
    }

    @Override
    public void removeSelection(Object eventlineObject) {
        if (eventlineObject == null) {
            throw new IllegalArgumentException("eventline object can not be NULL");
        }
        this.selections.remove(eventlineObject);
        this.fireSelectionModelEvent(new EventlineSelectionModelEvent((IEventlineSelectionModel)this, EventlineSelectionModelEvent.ID.EVENTLINE_OBJECTS_REMOVED, eventlineObject));
    }

    @Override
    public Object[] getSelection() {
        return this.selections.toArray();
    }

    @Override
    public void clearSelection() {
        this.selections.clear();
        this.fireSelectionModelEvent(new EventlineSelectionModelEvent((IEventlineSelectionModel)this, EventlineSelectionModelEvent.ID.SELECTION_CLEARED, null));
    }

    @Override
    public boolean isSelected(Object eventlineObject) {
        return this.selections.contains(eventlineObject);
    }

    @Override
    public void setSelectionMode(IEventlineSelectionModel.Mode mode) {
        if (this.mode.equals((Object)IEventlineSelectionModel.Mode.MULTIPLE_SELECTION) && mode.equals((Object)IEventlineSelectionModel.Mode.SINGLE_SELECTION) && this.selections.size() > 1) {
            Object first = this.selections.get(0);
            this.clearSelection();
            this.addSelection(first);
        }
        this.mode = mode;
    }

    @Override
    public IEventlineSelectionModel.Mode getSelectionMode() {
        return this.mode;
    }

    @Override
    public void addEventlineSelectionListener(IEventlineSelectionListener l) {
        if (l == null) {
            throw new IllegalArgumentException("listener can not be NULL");
        }
        this.listenerList.add(IEventlineSelectionListener.class, l);
    }

    @Override
    public void removeEventlineSelectionListener(IEventlineSelectionListener l) {
        if (l == null) {
            throw new IllegalArgumentException("listener can not be NULL");
        }
        this.listenerList.remove(IEventlineSelectionListener.class, l);
    }

    protected void fireSelectionModelEvent(EventlineSelectionModelEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IEventlineSelectionListener.class) continue;
            ((IEventlineSelectionListener)listeners[i + 1]).selectionChanged(evt);
        }
    }
}

