/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.icons;

import com.dlsc.flexgantt.icons.IIconMap;
import com.dlsc.flexgantt.icons.IconId;
import com.dlsc.flexgantt.icons.gif16eclipse.Gif16EclipseIconMap;
import java.awt.Dimension;
import java.awt.Image;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class IconRegistry {
    private static final Logger LOGGER = Logger.getLogger(IconRegistry.class.getName());
    private static IIconMap iconMap = new Gif16EclipseIconMap();

    private IconRegistry() {
    }

    public static Icon getIcon(IconId id) {
        LOGGER.fine("getting icon " + (Object)((Object)id));
        Icon icon = iconMap.getIcon(id);
        LOGGER.fine("returning icon = " + icon);
        return icon;
    }

    public static Icon getDisabledIcon(IconId id) {
        LOGGER.fine("getting disabled icon " + (Object)((Object)id));
        Icon icon = iconMap.getDisabledIcon(id);
        LOGGER.fine("returning disabled icon = " + icon);
        return icon;
    }

    public static Image getImage(IconId id) {
        ImageIcon icon = (ImageIcon)IconRegistry.getIcon(id);
        return icon.getImage();
    }

    public static void setIcon(IconId id, Icon icon) {
        LOGGER.fine("setting icon id = " + (Object)((Object)id) + " icon = " + icon);
        if (icon == null) {
            throw new IllegalArgumentException("icon can not be NULL");
        }
        iconMap.setIcon(id, icon);
    }

    public static IIconMap getIconMap() {
        return iconMap;
    }

    public static void setIconMap(IIconMap iconMap) {
        LOGGER.fine("setting icon map = " + iconMap);
        if (iconMap == null) {
            throw new IllegalArgumentException("icon map can not be NULL");
        }
        IconRegistry.iconMap = iconMap;
    }

    public static Dimension getIconDimension() {
        return iconMap.getIconDimension();
    }
}

