/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.command.layer;

import com.dlsc.flexgantt.command.AbstractCommand;
import com.dlsc.flexgantt.command.CommandException;
import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.model.ITimeSpan;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartModel;
import com.dlsc.flexgantt.model.gantt.IGanttChartNode;
import com.dlsc.flexgantt.model.gantt.ISpreadsheet;

public class DefaultChangeSpreadsheetValueCommand
extends AbstractCommand {
    private ITimeSpan timeSpan;
    private IGanttChartNode<?> node;
    private Object newValue;
    private Object oldValue;
    private DefaultGanttChartModel model;
    private ISpreadsheet spreadsheet;

    public DefaultChangeSpreadsheetValueCommand(DefaultGanttChartModel model, IGanttChartNode node, ISpreadsheet spreadsheet, ITimeSpan span, Object value) {
        super("Change Spreadsheet Value");
        if (model == null) {
            throw new IllegalArgumentException("model can not be NULL");
        }
        if (node == null) {
            throw new IllegalArgumentException("node can not be NULL");
        }
        if (spreadsheet == null) {
            throw new IllegalArgumentException("spreadsheet can not be NULL");
        }
        if (span == null) {
            throw new IllegalArgumentException("time span can not be NULL");
        }
        this.model = model;
        this.node = node;
        this.spreadsheet = spreadsheet;
        this.timeSpan = span;
        this.newValue = value;
    }

    @Override
    public void executeCommand(IProgressMonitor monitor) throws CommandException {
        this.oldValue = this.model.getSpreadsheetValue(this.spreadsheet, this.node, this.timeSpan);
        this.model.setSpreadsheetValue(this.node, this.spreadsheet, this.timeSpan, this.newValue);
    }

    @Override
    public void undoCommand(IProgressMonitor monitor) throws CommandException {
        this.model.setSpreadsheetValue(this.node, this.spreadsheet, this.timeSpan, this.oldValue);
    }

    public DefaultGanttChartModel getModel() {
        return this.model;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public IGanttChartNode<?> getNode() {
        return this.node;
    }

    public ITimeSpan getTimeSpan() {
        return this.timeSpan;
    }
}

