/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.flexgantt.command.layer;

import com.dlsc.flexgantt.command.AbstractCommand;
import com.dlsc.flexgantt.command.CommandException;
import com.dlsc.flexgantt.command.IProgressMonitor;
import com.dlsc.flexgantt.model.gantt.DefaultGanttChartModel;
import com.dlsc.flexgantt.model.gantt.ICapacityObject;
import com.dlsc.flexgantt.util.Messages;

public class DefaultChangeCapacityCommand
extends AbstractCommand {
    private ICapacityObject capacityObject;
    private DefaultGanttChartModel model;
    private double newCapacity;
    private double oldCapacity;

    public DefaultChangeCapacityCommand(ICapacityObject object, DefaultGanttChartModel model, double capacity) {
        super(Messages.getString("DefaultChangeCapacityCommand.NAME"));
        if (model == null) {
            throw new IllegalArgumentException("model can not be NULL");
        }
        if (object == null) {
            throw new IllegalArgumentException("capacity object can not be NULL");
        }
        this.capacityObject = object;
        this.model = model;
        this.newCapacity = capacity;
    }

    @Override
    public void executeCommand(IProgressMonitor monitor) throws CommandException {
        this.oldCapacity = this.capacityObject.getCapacityUsed();
        this.capacityObject.setCapacityUsed(this.newCapacity);
        this.model.timelineObjectChanged(this.capacityObject);
    }

    @Override
    public void undoCommand(IProgressMonitor monitor) throws CommandException {
        this.capacityObject.setCapacityUsed(this.oldCapacity);
        this.model.timelineObjectChanged(this.capacityObject);
    }

    public ICapacityObject getCapacityObject() {
        return this.capacityObject;
    }

    public DefaultGanttChartModel getModel() {
        return this.model;
    }

    public double getNewCapacity() {
        return this.newCapacity;
    }

    public double getOldCapacity() {
        return this.oldCapacity;
    }
}

