/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;

class ToggleActionPropertyChangeListener
implements PropertyChangeListener {
    private WeakReference<AbstractButton> buttonRef;

    public ToggleActionPropertyChangeListener(Action action, AbstractButton button) {
        if (this.shouldAddListener(action, button)) {
            this.buttonRef = new WeakReference<AbstractButton>(button);
            action.addPropertyChangeListener(this);
        }
    }

    protected synchronized boolean shouldAddListener(Action action, AbstractButton button) {
        this.releasePCLs(action);
        return !this.isToggling(action, button);
    }

    protected boolean isToggling(Action action, AbstractButton button) {
        if (!(action instanceof AbstractAction)) {
            return false;
        }
        PropertyChangeListener[] listeners = ((AbstractAction)action).getPropertyChangeListeners();
        for (int i2 = listeners.length - 1; i2 >= 0; --i2) {
            if (!(listeners[i2] instanceof ToggleActionPropertyChangeListener) || !((ToggleActionPropertyChangeListener)listeners[i2]).isToggling(button)) continue;
            return true;
        }
        return false;
    }

    protected void releasePCLs(Action action) {
        if (!(action instanceof AbstractAction)) {
            return;
        }
        PropertyChangeListener[] listeners = ((AbstractAction)action).getPropertyChangeListeners();
        for (int i2 = listeners.length - 1; i2 >= 0; --i2) {
            if (!(listeners[i2] instanceof ToggleActionPropertyChangeListener)) continue;
            ((ToggleActionPropertyChangeListener)listeners[i2]).checkReferent(action);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        AbstractButton button = this.checkReferent((Action)evt.getSource());
        if (button == null) {
            return;
        }
        String propertyName = evt.getPropertyName();
        if (propertyName.equals("selected")) {
            Boolean selected = (Boolean)evt.getNewValue();
            button.setSelected(selected);
        }
    }

    protected AbstractButton checkReferent(Action action) {
        AbstractButton button = null;
        if (this.buttonRef != null) {
            button = (AbstractButton)this.buttonRef.get();
        }
        if (button == null) {
            if (action != null) {
                action.removePropertyChangeListener(this);
            }
            this.buttonRef = null;
        }
        return button;
    }

    public boolean isToggling(AbstractButton button) {
        return button.equals(this.checkReferent(null));
    }
}

