/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.action;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.action.BoundAction;
import org.jdesktop.swingx.action.CompositeAction;
import org.jdesktop.swingx.action.ServerAction;
import org.jdesktop.swingx.action.TargetableAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionManager
extends ActionMap {
    private static ActionManager INSTANCE;

    public static ActionManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ActionManager();
        }
        return INSTANCE;
    }

    public static void setInstance(ActionManager manager) {
        INSTANCE = manager;
    }

    public Set<Object> getActionIDs() {
        Object[] keys = this.keys();
        if (keys == null) {
            return null;
        }
        return new HashSet<Object>(Arrays.asList(keys));
    }

    public Action addAction(Action action) {
        return this.addAction(action.getValue("ActionCommandKey"), action);
    }

    public Action addAction(Object id2, Action action) {
        this.put(id2, action);
        return action;
    }

    public Action getAction(Object id2) {
        return this.get(id2);
    }

    public TargetableAction getTargetableAction(Object id2) {
        Action a2 = this.getAction(id2);
        if (a2 instanceof TargetableAction) {
            return (TargetableAction)a2;
        }
        return null;
    }

    public BoundAction getBoundAction(Object id2) {
        Action a2 = this.getAction(id2);
        if (a2 instanceof BoundAction) {
            return (BoundAction)a2;
        }
        return null;
    }

    public ServerAction getServerAction(Object id2) {
        Action a2 = this.getAction(id2);
        if (a2 instanceof ServerAction) {
            return (ServerAction)a2;
        }
        return null;
    }

    public CompositeAction getCompositeAction(Object id2) {
        Action a2 = this.getAction(id2);
        if (a2 instanceof CompositeAction) {
            return (CompositeAction)a2;
        }
        return null;
    }

    private AbstractActionExt getStateChangeAction(Object id2) {
        AbstractActionExt aa;
        Action a2 = this.getAction(id2);
        if (a2 != null && a2 instanceof AbstractActionExt && (aa = (AbstractActionExt)a2).isStateAction()) {
            return aa;
        }
        return null;
    }

    public void setEnabled(Object id2, boolean enabled) {
        Action action = this.getAction(id2);
        if (action != null) {
            action.setEnabled(enabled);
        }
    }

    public boolean isEnabled(Object id2) {
        Action action = this.getAction(id2);
        if (action != null) {
            return action.isEnabled();
        }
        return false;
    }

    public void setSelected(Object id2, boolean selected) {
        AbstractActionExt action = this.getStateChangeAction(id2);
        if (action != null) {
            action.setSelected(selected);
        }
    }

    public boolean isSelected(Object id2) {
        AbstractActionExt action = this.getStateChangeAction(id2);
        if (action != null) {
            return action.isSelected();
        }
        return false;
    }

    static void printAction(PrintStream stream, Action action) {
        stream.println("Attributes for " + action.getValue("ActionCommandKey"));
        if (action instanceof AbstractAction) {
            Object[] keys = ((AbstractAction)action).getKeys();
            for (int i2 = 0; i2 < keys.length; ++i2) {
                stream.println("\tkey: " + keys[i2] + "\tvalue: " + action.getValue((String)keys[i2]));
            }
        }
    }

    public void registerCallback(Object id2, Object handler, String method) {
        BoundAction action = this.getBoundAction(id2);
        if (action != null) {
            action.registerCallback(handler, method);
        }
    }

    public boolean isStateAction(Object id2) {
        Action action = this.getAction(id2);
        if (action != null && action instanceof AbstractActionExt) {
            return ((AbstractActionExt)action).isStateAction();
        }
        return false;
    }

    public boolean isTargetableAction(Object id2) {
        return this.getTargetableAction(id2) != null;
    }

    public boolean isBoundAction(Object id2) {
        return this.getBoundAction(id2) != null;
    }

    public boolean isCompositeAction(Object id2) {
        return this.getCompositeAction(id2) != null;
    }

    public boolean isServerAction(Object id2) {
        return this.getServerAction(id2) != null;
    }
}

