/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application.session;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.jdesktop.application.session.PropertySupport;
import org.jdesktop.application.session.TableState;

public class TableProperty
implements PropertySupport {
    private void checkComponent(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("null component");
        }
        if (!(component instanceof JTable)) {
            throw new IllegalArgumentException("invalid component");
        }
    }

    @Override
    public Object getSessionState(Component c2) {
        this.checkComponent(c2);
        JTable table = (JTable)c2;
        int[] columnWidths = new int[table.getColumnCount()];
        boolean resizableColumnExists = false;
        for (int i2 = 0; i2 < columnWidths.length; ++i2) {
            TableColumn tc2 = table.getColumnModel().getColumn(i2);
            int n2 = columnWidths[i2] = tc2.getResizable() ? tc2.getWidth() : -1;
            if (!tc2.getResizable()) continue;
            resizableColumnExists = true;
        }
        return resizableColumnExists ? new TableState(columnWidths) : null;
    }

    @Override
    public void setSessionState(Component c2, Object state) {
        this.checkComponent(c2);
        if (!(state instanceof TableState)) {
            throw new IllegalArgumentException("invalid state");
        }
        JTable table = (JTable)c2;
        int[] columnWidths = ((TableState)state).getColumnWidths();
        if (table.getColumnCount() == columnWidths.length) {
            for (int i2 = 0; i2 < columnWidths.length; ++i2) {
                TableColumn tc2;
                if (columnWidths[i2] == -1 || !(tc2 = table.getColumnModel().getColumn(i2)).getResizable()) continue;
                tc2.setPreferredWidth(columnWidths[i2]);
            }
        }
    }
}

