/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.LocalStorage;
import org.jdesktop.application.session.PropertySupport;
import org.jdesktop.application.session.SplitPaneProperty;
import org.jdesktop.application.session.TabbedPaneProperty;
import org.jdesktop.application.session.TableProperty;
import org.jdesktop.application.session.WindowProperty;

public class SessionStorage {
    private static Logger logger = Logger.getLogger(SessionStorage.class.getName());
    private final Map<Class, PropertySupport> propertyMap;
    private final ApplicationContext context;

    protected SessionStorage(ApplicationContext context) {
        if (context == null) {
            throw new IllegalArgumentException("null context");
        }
        this.context = context;
        this.propertyMap = new HashMap<Class, PropertySupport>();
        this.propertyMap.put(Window.class, new WindowProperty());
        this.propertyMap.put(JTabbedPane.class, new TabbedPaneProperty());
        this.propertyMap.put(JSplitPane.class, new SplitPaneProperty());
        this.propertyMap.put(JTable.class, new TableProperty());
    }

    protected final ApplicationContext getContext() {
        return this.context;
    }

    private void checkSaveRestoreArgs(Component root, String fileName) {
        if (root == null) {
            throw new IllegalArgumentException("null root");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("null fileName");
        }
    }

    private String getComponentName(Component c2) {
        return c2.getName();
    }

    private String getComponentPathname(Component c2) {
        String name = this.getComponentName(c2);
        if (name == null) {
            return null;
        }
        StringBuilder path = new StringBuilder(name);
        while (c2.getParent() != null && !(c2 instanceof Window) && !(c2 instanceof Applet)) {
            name = this.getComponentName(c2 = c2.getParent());
            if (name == null) {
                int n2 = c2.getParent().getComponentZOrder(c2);
                if (n2 >= 0) {
                    Class<?> cls = c2.getClass();
                    name = cls.getSimpleName();
                    if (name.length() == 0) {
                        name = "Anonymous" + cls.getSuperclass().getSimpleName();
                    }
                    name = name + n2;
                } else {
                    logger.warning("Couldn't compute pathname for " + c2);
                    return null;
                }
            }
            path.append("/").append(name);
        }
        return path.toString();
    }

    private void saveTree(List<Component> roots, Map<String, Object> stateMap) {
        ArrayList<Component> allChildren = new ArrayList<Component>();
        for (Component root : roots) {
            Component[] children;
            Object state;
            String pathname;
            PropertySupport p2;
            if (root != null && (p2 = this.getProperty(root)) != null && (pathname = this.getComponentPathname(root)) != null && (state = p2.getSessionState(root)) != null) {
                stateMap.put(pathname, state);
            }
            if (!(root instanceof Container) || (children = ((Container)root).getComponents()) == null || children.length <= 0) continue;
            Collections.addAll(allChildren, children);
        }
        if (allChildren.size() > 0) {
            this.saveTree(allChildren, stateMap);
        }
    }

    public void save(Component root, String fileName) throws IOException {
        this.checkSaveRestoreArgs(root, fileName);
        HashMap<String, Object> stateMap = new HashMap<String, Object>();
        this.saveTree(Collections.singletonList(root), stateMap);
        LocalStorage lst = this.getContext().getLocalStorage();
        lst.save(stateMap, fileName);
    }

    private void restoreTree(List<Component> roots, Map<String, Object> stateMap) {
        ArrayList<Component> allChildren = new ArrayList<Component>();
        for (Component root : roots) {
            Component[] children;
            String pathname;
            PropertySupport p2;
            if (root != null && (p2 = this.getProperty(root)) != null && (pathname = this.getComponentPathname(root)) != null) {
                Object state = stateMap.get(pathname);
                if (state != null) {
                    p2.setSessionState(root, state);
                } else {
                    logger.warning("No saved state for " + root);
                }
            }
            if (!(root instanceof Container) || (children = ((Container)root).getComponents()) == null || children.length <= 0) continue;
            Collections.addAll(allChildren, children);
        }
        if (allChildren.size() > 0) {
            this.restoreTree(allChildren, stateMap);
        }
    }

    public void restore(Component root, String fileName) throws IOException {
        this.checkSaveRestoreArgs(root, fileName);
        LocalStorage lst = this.getContext().getLocalStorage();
        Map stateMap = (Map)lst.load(fileName);
        if (stateMap != null) {
            this.restoreTree(Collections.singletonList(root), stateMap);
        }
    }

    private void checkClassArg(Class cls) {
        if (cls == null) {
            throw new IllegalArgumentException("null class");
        }
    }

    public PropertySupport getProperty(Class cls) {
        this.checkClassArg(cls);
        while (cls != null) {
            PropertySupport p2 = this.propertyMap.get(cls);
            if (p2 != null) {
                return p2;
            }
            cls = cls.getSuperclass();
        }
        return null;
    }

    public void putProperty(Class cls, PropertySupport propertySupport) {
        this.checkClassArg(cls);
        if (propertySupport == null) {
            this.propertyMap.remove(cls);
            return;
        }
        this.propertyMap.put(cls, propertySupport);
    }

    public final PropertySupport getProperty(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("null component");
        }
        if (component instanceof PropertySupport) {
            return (PropertySupport)((Object)component);
        }
        PropertySupport p2 = null;
        if (component instanceof JComponent) {
            Object v2 = ((JComponent)component).getClientProperty(PropertySupport.class);
            p2 = v2 instanceof PropertySupport ? (PropertySupport)v2 : null;
        }
        return p2 != null ? p2 : this.getProperty(component.getClass());
    }
}

