/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.PaintEvent;
import java.beans.Beans;
import java.lang.reflect.Constructor;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jdesktop.application.AbstractBean;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ProxyActions;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.application.View;
import org.jdesktop.application.utils.AppHelper;
import org.jdesktop.application.utils.OSXAdapter;
import org.jdesktop.application.utils.PlatformType;

@ProxyActions(value={"cut", "copy", "paste", "delete"})
public abstract class Application
extends AbstractBean {
    public static final String KEY_APPLICATION_TITLE = "Application.title";
    public static final String KEY_APPLICATION_ICON = "Application.icon";
    public static final String KEY_APPLICATION_VENDOR_ID = "Application.vendorId";
    private static final Logger logger = Logger.getLogger(Application.class.getName());
    private static Application application = null;
    private final List<ExitListener> exitListeners = new CopyOnWriteArrayList<ExitListener>();
    private final ApplicationContext context = new ApplicationContext();
    protected boolean ready;

    protected Application() {
    }

    public static synchronized <T extends Application> void launch(final Class<T> applicationClass, final String[] args) {
        Runnable doCreateAndShowGUI = new Runnable(){

            @Override
            public void run() {
                try {
                    application = (Application)Application.create(applicationClass);
                    application.initialize(args);
                    application.startup();
                    application.waitForReady();
                }
                catch (Exception e2) {
                    String msg = String.format("Application %s failed to launch", applicationClass);
                    logger.log(Level.SEVERE, msg, e2);
                    throw new Error(msg, e2);
                }
            }
        };
        SwingUtilities.invokeLater(doCreateAndShowGUI);
    }

    static <T extends Application> T create(Class<T> applicationClass) throws Exception {
        Application application;
        block16: {
            Constructor<T> ctor;
            if (!Beans.isDesignTime()) {
                try {
                    System.setProperty("java.net.useSystemProxies", "true");
                }
                catch (SecurityException ignoreException) {
                    // empty catch block
                }
            }
            if (!(ctor = applicationClass.getDeclaredConstructor(new Class[0])).isAccessible()) {
                try {
                    ctor.setAccessible(true);
                }
                catch (SecurityException ignore) {
                    // empty catch block
                }
            }
            application = (Application)ctor.newInstance(new Object[0]);
            ApplicationContext ctx = application.getContext();
            ctx.setApplicationClass(applicationClass);
            ctx.setApplication(application);
            ResourceMap appResourceMap = ctx.getResourceMap();
            PlatformType platform = AppHelper.getPlatform();
            appResourceMap.putResource("platform", (Object)platform);
            if (PlatformType.OS_X.equals((Object)platform)) {
                try {
                    OSXAdapter.setQuitHandler(application, Application.class.getDeclaredMethod("handleQuit", null));
                }
                catch (Exception e2) {
                    logger.log(Level.SEVERE, "Cannot set Mac Os X specific handler for Quit event", e2);
                }
            }
            if (!Beans.isDesignTime()) {
                String key = "Application.lookAndFeel";
                String lnfResource = appResourceMap.getString(key, new Object[0]);
                String lnf = lnfResource == null ? "system" : lnfResource;
                try {
                    if (lnf.equalsIgnoreCase("system")) {
                        String name = UIManager.getSystemLookAndFeelClassName();
                        UIManager.setLookAndFeel(name);
                        break block16;
                    }
                    if (lnf.equalsIgnoreCase("nimbus")) {
                        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                            if (!"Nimbus".equals(info.getName())) continue;
                            UIManager.setLookAndFeel(info.getClassName());
                            break block16;
                        }
                        break block16;
                    }
                    if (!lnf.equalsIgnoreCase("default")) {
                        UIManager.setLookAndFeel(lnf);
                    }
                }
                catch (Exception e3) {
                    String s2 = "Couldn't set LookandFeel " + key + " = \"" + lnfResource + "\"";
                    logger.log(Level.WARNING, s2, e3);
                }
            }
        }
        return (T)application;
    }

    void waitForReady() {
        new DoWaitForEmptyEventQ().execute();
    }

    protected void initialize(String[] args) {
    }

    protected abstract void startup();

    protected void ready() {
    }

    protected void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForEmptyEventQ(JPanel placeHolder) {
        boolean qEmpty = false;
        EventQueue q2 = Toolkit.getDefaultToolkit().getSystemEventQueue();
        while (!qEmpty) {
            NotifyingEvent e2 = new NotifyingEvent(placeHolder);
            q2.postEvent(e2);
            NotifyingEvent notifyingEvent = e2;
            synchronized (notifyingEvent) {
                while (!e2.isDispatched()) {
                    try {
                        e2.wait();
                    }
                    catch (InterruptedException ie) {}
                }
                qEmpty = e2.isEventQEmpty();
            }
        }
    }

    public final void exit() {
        this.exit(null);
    }

    public boolean handleQuit() {
        this.exit();
        return false;
    }

    public void exit(final EventObject event) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                for (ExitListener listener : Application.this.exitListeners) {
                    if (listener.canExit(event)) continue;
                    return;
                }
                try {
                    for (ExitListener listener : Application.this.exitListeners) {
                        try {
                            listener.willExit(event);
                        }
                        catch (Exception e2) {
                            logger.log(Level.WARNING, "ExitListener.willExit() failed", e2);
                        }
                    }
                    Application.this.shutdown();
                }
                catch (Exception e3) {
                    logger.log(Level.WARNING, "unexpected error in Application.shutdown()", e3);
                }
                finally {
                    Application.this.end();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void end() {
        Runtime.getRuntime().exit(0);
    }

    public void addExitListener(ExitListener listener) {
        this.exitListeners.add(listener);
    }

    public void removeExitListener(ExitListener listener) {
        this.exitListeners.remove(listener);
    }

    public ExitListener[] getExitListeners() {
        int size = this.exitListeners.size();
        return this.exitListeners.toArray(new ExitListener[size]);
    }

    @Action
    public void quit(ActionEvent e2) {
        this.exit(e2);
    }

    public final ApplicationContext getContext() {
        return this.context;
    }

    public static synchronized <T extends Application> T getInstance(Class<T> applicationClass) {
        if (Beans.isDesignTime() && application == null) {
            try {
                application = Application.create(applicationClass);
            }
            catch (Exception ex) {
                String msg = String.format("Couldn't construct %s", applicationClass);
                Logger.getLogger(Application.class.getName()).log(Level.SEVERE, msg, ex);
                throw new Error(msg, ex);
            }
        }
        Application.checkApplicationLaunched();
        return (T)((Application)applicationClass.cast(application));
    }

    public static synchronized Application getInstance() {
        if (Beans.isDesignTime() && application == null) {
            application = new DesignTimeApplication();
        }
        Application.checkApplicationLaunched();
        return application;
    }

    private static void checkApplicationLaunched() throws IllegalStateException {
        if (application == null) {
            throw new IllegalStateException("Application is not launched.");
        }
    }

    public void show(View view) {
        Window window = (Window)view.getRootPane().getParent();
        if (window != null) {
            window.pack();
            window.setVisible(true);
        }
    }

    public void hide(View view) {
        view.getRootPane().getParent().setVisible(false);
    }

    public boolean isReady() {
        return this.ready;
    }

    private static final class DesignTimeApplication
    extends Application {
        protected DesignTimeApplication() {
            ApplicationContext ctx = this.getContext();
            ctx.setApplicationClass(this.getClass());
            ctx.setApplication(this);
            ResourceMap appResourceMap = ctx.getResourceMap();
            appResourceMap.setPlatform(PlatformType.DEFAULT);
        }

        @Override
        protected void startup() {
        }
    }

    public static interface ExitListener
    extends EventListener {
        public boolean canExit(EventObject var1);

        public void willExit(EventObject var1);
    }

    private class DoWaitForEmptyEventQ
    extends Task<Void, Void> {
        private final JPanel placeHolder;

        DoWaitForEmptyEventQ() {
            super(Application.this);
            this.placeHolder = new JPanel();
        }

        @Override
        protected Void doInBackground() {
            Application.this.waitForEmptyEventQ(this.placeHolder);
            return null;
        }

        @Override
        protected void finished() {
            Application.this.ready = true;
            Application.this.ready();
        }
    }

    private static class NotifyingEvent
    extends PaintEvent
    implements ActiveEvent {
        private boolean dispatched = false;
        private boolean qEmpty = false;

        NotifyingEvent(Component c2) {
            super(c2, 801, null);
        }

        synchronized boolean isDispatched() {
            return this.dispatched;
        }

        synchronized boolean isEventQEmpty() {
            return this.qEmpty;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatch() {
            EventQueue q2 = Toolkit.getDefaultToolkit().getSystemEventQueue();
            NotifyingEvent notifyingEvent = this;
            synchronized (notifyingEvent) {
                this.qEmpty = q2.peekEvent() == null;
                this.dispatched = true;
                this.notifyAll();
            }
        }
    }
}

