/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LocaleUtil;

@Internal
public class HexDump {
    public static final String EOL = System.getProperty("line.separator");
    public static final Charset UTF8 = StandardCharsets.UTF_8;

    private HexDump() {
    }

    public static void dump(byte[] data, long offset, OutputStream stream, int index, int length) throws IOException, ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (stream == null) {
            throw new IllegalArgumentException("cannot write to nullstream");
        }
        OutputStreamWriter osw = new OutputStreamWriter(stream, UTF8);
        osw.write(HexDump.dump(data, offset, index, length));
        osw.flush();
    }

    public static synchronized void dump(byte[] data, long offset, OutputStream stream, int index) throws IOException, ArrayIndexOutOfBoundsException, IllegalArgumentException {
        HexDump.dump(data, offset, stream, index, Integer.MAX_VALUE);
    }

    public static String dump(byte[] data, long offset, int index) {
        return HexDump.dump(data, offset, index, Integer.MAX_VALUE);
    }

    public static String dump(byte[] data, long offset, int index, int length) {
        int data_length;
        if (data == null || data.length == 0) {
            return "No Data" + EOL;
        }
        int n2 = data_length = length == Integer.MAX_VALUE || length < 0 || index + length < 0 ? data.length : Math.min(data.length, index + length);
        if (index < 0 || index >= data.length) {
            String err = "illegal index: " + index + " into array of length " + data.length;
            throw new ArrayIndexOutOfBoundsException(err);
        }
        long display_offset = offset + (long)index;
        StringBuilder buffer = new StringBuilder(74);
        for (int j2 = index; j2 < data_length; j2 += 16) {
            int k2;
            int chars_read = data_length - j2;
            if (chars_read > 16) {
                chars_read = 16;
            }
            HexDump.writeHex(buffer, display_offset, 8, "");
            for (k2 = 0; k2 < 16; ++k2) {
                if (k2 < chars_read) {
                    HexDump.writeHex(buffer, data[k2 + j2], 2, " ");
                    continue;
                }
                buffer.append("   ");
            }
            buffer.append(' ');
            for (k2 = 0; k2 < chars_read; ++k2) {
                buffer.append(HexDump.toAscii(data[k2 + j2]));
            }
            buffer.append(EOL);
            display_offset += (long)chars_read;
        }
        return buffer.toString();
    }

    public static char toAscii(int dataB) {
        int charB = dataB & 0xFF;
        if (Character.isISOControl((char)charB)) {
            return '.';
        }
        switch (charB) {
            case 221: 
            case 255: {
                charB = 46;
                break;
            }
        }
        return (char)charB;
    }

    public static String toHex(byte[] value) {
        StringBuilder retVal = new StringBuilder();
        retVal.append('[');
        if (value != null && value.length > 0) {
            for (int x2 = 0; x2 < value.length; ++x2) {
                if (x2 > 0) {
                    retVal.append(", ");
                }
                retVal.append(HexDump.toHex(value[x2]));
            }
        }
        retVal.append(']');
        return retVal.toString();
    }

    public static String toHex(short[] value) {
        StringBuilder retVal = new StringBuilder();
        retVal.append('[');
        for (int x2 = 0; x2 < value.length; ++x2) {
            if (x2 > 0) {
                retVal.append(", ");
            }
            retVal.append(HexDump.toHex(value[x2]));
        }
        retVal.append(']');
        return retVal.toString();
    }

    public static String toHex(byte[] value, int bytesPerLine) {
        if (value.length == 0) {
            return ": 0";
        }
        int digits = (int)Math.round(Math.log(value.length) / Math.log(10.0) + 0.5);
        StringBuilder retVal = new StringBuilder();
        HexDump.writeHex(retVal, 0L, digits, "");
        retVal.append(": ");
        int i2 = -1;
        for (int x2 = 0; x2 < value.length; ++x2) {
            if (++i2 == bytesPerLine) {
                retVal.append('\n');
                HexDump.writeHex(retVal, x2, digits, "");
                retVal.append(": ");
                i2 = 0;
            } else if (x2 > 0) {
                retVal.append(", ");
            }
            retVal.append(HexDump.toHex(value[x2]));
        }
        return retVal.toString();
    }

    public static String toHex(short value) {
        StringBuilder sb2 = new StringBuilder(4);
        HexDump.writeHex(sb2, value & 0xFFFF, 4, "");
        return sb2.toString();
    }

    public static String toHex(byte value) {
        StringBuilder sb2 = new StringBuilder(2);
        HexDump.writeHex(sb2, value & 0xFF, 2, "");
        return sb2.toString();
    }

    public static String toHex(int value) {
        StringBuilder sb2 = new StringBuilder(8);
        HexDump.writeHex(sb2, (long)value & 0xFFFFFFFFL, 8, "");
        return sb2.toString();
    }

    public static String toHex(long value) {
        StringBuilder sb2 = new StringBuilder(16);
        HexDump.writeHex(sb2, value, 16, "");
        return sb2.toString();
    }

    public static String toHex(String value) {
        return value == null || value.length() == 0 ? "[]" : HexDump.toHex(value.getBytes(LocaleUtil.CHARSET_1252));
    }

    public static void dump(InputStream in, PrintStream out, int start, int bytesToDump) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        if (bytesToDump == -1) {
            int c2 = in.read();
            while (c2 != -1) {
                buf.write(c2);
                c2 = in.read();
            }
        } else {
            int c3;
            int bytesRemaining = bytesToDump;
            while (bytesRemaining-- > 0 && (c3 = in.read()) != -1) {
                buf.write(c3);
            }
        }
        byte[] data = buf.toByteArray();
        HexDump.dump(data, 0L, out, start, data.length);
    }

    public static String longToHex(long value) {
        StringBuilder sb2 = new StringBuilder(18);
        HexDump.writeHex(sb2, value, 16, "0x");
        return sb2.toString();
    }

    public static String intToHex(int value) {
        StringBuilder sb2 = new StringBuilder(10);
        HexDump.writeHex(sb2, (long)value & 0xFFFFFFFFL, 8, "0x");
        return sb2.toString();
    }

    public static String shortToHex(int value) {
        StringBuilder sb2 = new StringBuilder(6);
        HexDump.writeHex(sb2, (long)value & 0xFFFFL, 4, "0x");
        return sb2.toString();
    }

    public static String byteToHex(int value) {
        StringBuilder sb2 = new StringBuilder(4);
        HexDump.writeHex(sb2, (long)value & 0xFFL, 2, "0x");
        return sb2.toString();
    }

    private static void writeHex(StringBuilder sb2, long value, int nDigits, String prefix) {
        sb2.append(prefix);
        char[] buf = new char[nDigits];
        long acc = value;
        for (int i2 = nDigits - 1; i2 >= 0; --i2) {
            int digit = Math.toIntExact(acc & 0xFL);
            buf[i2] = (char)(digit < 10 ? 48 + digit : 65 + digit - 10);
            acc >>>= 4;
        }
        sb2.append(buf);
    }

    public static void main(String[] args) throws IOException {
        FileInputStream in = new FileInputStream(args[0]);
        byte[] b2 = IOUtils.toByteArray(in);
        ((InputStream)in).close();
        System.out.println(HexDump.dump(b2, 0L, 0));
    }
}

