/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.util;

import org.apache.poi.ss.util.ExpandedDouble;
import org.apache.poi.ss.util.NormalisedDecimal;

public final class NumberToTextConverter {
    private static final long EXCEL_NAN_BITS = -276939487313920L;
    private static final int MAX_TEXT_LEN = 20;

    private NumberToTextConverter() {
    }

    public static String toText(double value) {
        return NumberToTextConverter.rawDoubleBitsToText(Double.doubleToLongBits(value));
    }

    static String rawDoubleBitsToText(long pRawBits) {
        boolean isNegative;
        long rawBits = pRawBits;
        boolean bl = isNegative = rawBits < 0L;
        if (isNegative) {
            rawBits &= Long.MAX_VALUE;
        }
        if (rawBits == 0L) {
            return isNegative ? "-0" : "0";
        }
        ExpandedDouble ed2 = new ExpandedDouble(rawBits);
        if (ed2.getBinaryExponent() < -1022) {
            return isNegative ? "-0" : "0";
        }
        if (ed2.getBinaryExponent() == 1024) {
            if (rawBits == -276939487313920L) {
                return "3.484840871308E+308";
            }
            isNegative = false;
        }
        NormalisedDecimal nd2 = ed2.normaliseBaseTen();
        StringBuilder sb2 = new StringBuilder(21);
        if (isNegative) {
            sb2.append('-');
        }
        NumberToTextConverter.convertToText(sb2, nd2);
        return sb2.toString();
    }

    private static void convertToText(StringBuilder sb2, NormalisedDecimal pnd) {
        String decimalDigits;
        NormalisedDecimal rnd = pnd.roundUnits();
        int decExponent = rnd.getDecimalExponent();
        if (Math.abs(decExponent) > 98) {
            decimalDigits = rnd.getSignificantDecimalDigitsLastDigitRounded();
            if (decimalDigits.length() == 16) {
                ++decExponent;
            }
        } else {
            decimalDigits = rnd.getSignificantDecimalDigits();
        }
        int countSigDigits = NumberToTextConverter.countSignifantDigits(decimalDigits);
        if (decExponent < 0) {
            NumberToTextConverter.formatLessThanOne(sb2, decimalDigits, decExponent, countSigDigits);
        } else {
            NumberToTextConverter.formatGreaterThanOne(sb2, decimalDigits, decExponent, countSigDigits);
        }
    }

    private static void formatLessThanOne(StringBuilder sb2, String decimalDigits, int decExponent, int countSigDigits) {
        int nLeadingZeros = -decExponent - 1;
        int normalLength = 2 + nLeadingZeros + countSigDigits;
        if (NumberToTextConverter.needsScientificNotation(normalLength)) {
            sb2.append(decimalDigits.charAt(0));
            if (countSigDigits > 1) {
                sb2.append('.');
                sb2.append(decimalDigits.subSequence(1, countSigDigits));
            }
            sb2.append("E-");
            NumberToTextConverter.appendExp(sb2, -decExponent);
            return;
        }
        sb2.append("0.");
        for (int i2 = nLeadingZeros; i2 > 0; --i2) {
            sb2.append('0');
        }
        sb2.append(decimalDigits.subSequence(0, countSigDigits));
    }

    private static void formatGreaterThanOne(StringBuilder sb2, String decimalDigits, int decExponent, int countSigDigits) {
        if (decExponent > 19) {
            sb2.append(decimalDigits.charAt(0));
            if (countSigDigits > 1) {
                sb2.append('.');
                sb2.append(decimalDigits.subSequence(1, countSigDigits));
            }
            sb2.append("E+");
            NumberToTextConverter.appendExp(sb2, decExponent);
            return;
        }
        int nFractionalDigits = countSigDigits - decExponent - 1;
        if (nFractionalDigits > 0) {
            sb2.append(decimalDigits.subSequence(0, decExponent + 1));
            sb2.append('.');
            sb2.append(decimalDigits.subSequence(decExponent + 1, countSigDigits));
            return;
        }
        sb2.append(decimalDigits.subSequence(0, countSigDigits));
        for (int i2 = -nFractionalDigits; i2 > 0; --i2) {
            sb2.append('0');
        }
    }

    private static boolean needsScientificNotation(int nDigits) {
        return nDigits > 20;
    }

    private static int countSignifantDigits(String sb2) {
        int result = sb2.length() - 1;
        while (sb2.charAt(result) == '0') {
            if (--result >= 0) continue;
            throw new RuntimeException("No non-zero digits found");
        }
        return result + 1;
    }

    private static void appendExp(StringBuilder sb2, int val) {
        if (val < 10) {
            sb2.append('0');
            sb2.append((char)(48 + val));
            return;
        }
        sb2.append(val);
    }
}

