/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.ptg;

import org.apache.poi.ss.formula.SheetNameFormatter;
import org.apache.poi.ss.formula.ptg.OperandPtg;
import org.apache.poi.ss.formula.ptg.Pxg;
import org.apache.poi.ss.usermodel.FormulaError;
import org.apache.poi.util.LittleEndianOutput;

public final class Deleted3DPxg
extends OperandPtg
implements Pxg {
    private int externalWorkbookNumber = -1;
    private String sheetName;

    public Deleted3DPxg(int externalWorkbookNumber, String sheetName) {
        this.externalWorkbookNumber = externalWorkbookNumber;
        this.sheetName = sheetName;
    }

    public Deleted3DPxg(Deleted3DPxg other) {
        super(other);
        this.externalWorkbookNumber = other.externalWorkbookNumber;
        this.sheetName = other.sheetName;
    }

    public Deleted3DPxg(String sheetName) {
        this(-1, sheetName);
    }

    @Override
    public String toString() {
        StringBuilder sb2 = new StringBuilder();
        sb2.append(this.getClass().getName());
        sb2.append(" [");
        if (this.externalWorkbookNumber >= 0) {
            sb2.append(" [");
            sb2.append("workbook=").append(this.getExternalWorkbookNumber());
            sb2.append("] ");
        }
        sb2.append("sheet=").append(this.getSheetName());
        sb2.append(" ! ");
        sb2.append(FormulaError.REF.getString());
        sb2.append("]");
        return sb2.toString();
    }

    @Override
    public int getExternalWorkbookNumber() {
        return this.externalWorkbookNumber;
    }

    @Override
    public String getSheetName() {
        return this.sheetName;
    }

    @Override
    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    @Override
    public String toFormulaString() {
        StringBuilder sb2 = new StringBuilder(64);
        if (this.externalWorkbookNumber >= 0) {
            sb2.append('[');
            sb2.append(this.externalWorkbookNumber);
            sb2.append(']');
        }
        if (this.sheetName != null) {
            SheetNameFormatter.appendFormat(sb2, this.sheetName);
        }
        sb2.append('!');
        sb2.append(FormulaError.REF.getString());
        return sb2.toString();
    }

    @Override
    public byte getDefaultOperandClass() {
        return 32;
    }

    @Override
    public int getSize() {
        return 1;
    }

    @Override
    public void write(LittleEndianOutput out) {
        throw new IllegalStateException("XSSF-only Ptg, should not be serialised");
    }

    @Override
    public Deleted3DPxg copy() {
        return new Deleted3DPxg(this);
    }
}

