/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.distribution.UniformIntegerDistribution;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.MathInternalError;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NonMonotonicSequenceException;
import org.apache.commons.math3.exception.NotANumberException;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathUtils;
import org.apache.commons.math3.util.Precision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MathArrays {
    private MathArrays() {
    }

    public static double[] scale(double val, double[] arr) {
        double[] newArr = new double[arr.length];
        for (int i2 = 0; i2 < arr.length; ++i2) {
            newArr[i2] = arr[i2] * val;
        }
        return newArr;
    }

    public static void scaleInPlace(double val, double[] arr) {
        int i2 = 0;
        while (i2 < arr.length) {
            int n2 = i2++;
            arr[n2] = arr[n2] * val;
        }
    }

    public static double[] ebeAdd(double[] a2, double[] b2) throws DimensionMismatchException {
        MathArrays.checkEqualLength(a2, b2);
        double[] result = (double[])a2.clone();
        for (int i2 = 0; i2 < a2.length; ++i2) {
            int n2 = i2;
            result[n2] = result[n2] + b2[i2];
        }
        return result;
    }

    public static double[] ebeSubtract(double[] a2, double[] b2) throws DimensionMismatchException {
        MathArrays.checkEqualLength(a2, b2);
        double[] result = (double[])a2.clone();
        for (int i2 = 0; i2 < a2.length; ++i2) {
            int n2 = i2;
            result[n2] = result[n2] - b2[i2];
        }
        return result;
    }

    public static double[] ebeMultiply(double[] a2, double[] b2) throws DimensionMismatchException {
        MathArrays.checkEqualLength(a2, b2);
        double[] result = (double[])a2.clone();
        for (int i2 = 0; i2 < a2.length; ++i2) {
            int n2 = i2;
            result[n2] = result[n2] * b2[i2];
        }
        return result;
    }

    public static double[] ebeDivide(double[] a2, double[] b2) throws DimensionMismatchException {
        MathArrays.checkEqualLength(a2, b2);
        double[] result = (double[])a2.clone();
        for (int i2 = 0; i2 < a2.length; ++i2) {
            int n2 = i2;
            result[n2] = result[n2] / b2[i2];
        }
        return result;
    }

    public static double distance1(double[] p1, double[] p2) throws DimensionMismatchException {
        MathArrays.checkEqualLength(p1, p2);
        double sum = 0.0;
        for (int i2 = 0; i2 < p1.length; ++i2) {
            sum += FastMath.abs(p1[i2] - p2[i2]);
        }
        return sum;
    }

    public static int distance1(int[] p1, int[] p2) throws DimensionMismatchException {
        MathArrays.checkEqualLength(p1, p2);
        int sum = 0;
        for (int i2 = 0; i2 < p1.length; ++i2) {
            sum += FastMath.abs(p1[i2] - p2[i2]);
        }
        return sum;
    }

    public static double distance(double[] p1, double[] p2) throws DimensionMismatchException {
        MathArrays.checkEqualLength(p1, p2);
        double sum = 0.0;
        for (int i2 = 0; i2 < p1.length; ++i2) {
            double dp = p1[i2] - p2[i2];
            sum += dp * dp;
        }
        return FastMath.sqrt(sum);
    }

    public static double cosAngle(double[] v1, double[] v2) {
        return MathArrays.linearCombination(v1, v2) / (MathArrays.safeNorm(v1) * MathArrays.safeNorm(v2));
    }

    public static double distance(int[] p1, int[] p2) throws DimensionMismatchException {
        MathArrays.checkEqualLength(p1, p2);
        double sum = 0.0;
        for (int i2 = 0; i2 < p1.length; ++i2) {
            double dp = p1[i2] - p2[i2];
            sum += dp * dp;
        }
        return FastMath.sqrt(sum);
    }

    public static double distanceInf(double[] p1, double[] p2) throws DimensionMismatchException {
        MathArrays.checkEqualLength(p1, p2);
        double max = 0.0;
        for (int i2 = 0; i2 < p1.length; ++i2) {
            max = FastMath.max(max, FastMath.abs(p1[i2] - p2[i2]));
        }
        return max;
    }

    public static int distanceInf(int[] p1, int[] p2) throws DimensionMismatchException {
        MathArrays.checkEqualLength(p1, p2);
        int max = 0;
        for (int i2 = 0; i2 < p1.length; ++i2) {
            max = FastMath.max(max, FastMath.abs(p1[i2] - p2[i2]));
        }
        return max;
    }

    public static <T extends Comparable<? super T>> boolean isMonotonic(T[] val, OrderDirection dir, boolean strict) {
        T previous = val[0];
        int max = val.length;
        for (int i2 = 1; i2 < max; ++i2) {
            switch (dir) {
                case INCREASING: {
                    int comp = previous.compareTo(val[i2]);
                    if (!(strict ? comp >= 0 : comp > 0)) break;
                    return false;
                }
                case DECREASING: {
                    int comp = val[i2].compareTo(previous);
                    if (!(strict ? comp >= 0 : comp > 0)) break;
                    return false;
                }
                default: {
                    throw new MathInternalError();
                }
            }
            previous = val[i2];
        }
        return true;
    }

    public static boolean isMonotonic(double[] val, OrderDirection dir, boolean strict) {
        return MathArrays.checkOrder(val, dir, strict, false);
    }

    public static boolean checkEqualLength(double[] a2, double[] b2, boolean abort) {
        if (a2.length == b2.length) {
            return true;
        }
        if (abort) {
            throw new DimensionMismatchException(a2.length, b2.length);
        }
        return false;
    }

    public static void checkEqualLength(double[] a2, double[] b2) {
        MathArrays.checkEqualLength(a2, b2, true);
    }

    public static boolean checkEqualLength(int[] a2, int[] b2, boolean abort) {
        if (a2.length == b2.length) {
            return true;
        }
        if (abort) {
            throw new DimensionMismatchException(a2.length, b2.length);
        }
        return false;
    }

    public static void checkEqualLength(int[] a2, int[] b2) {
        MathArrays.checkEqualLength(a2, b2, true);
    }

    public static boolean checkOrder(double[] val, OrderDirection dir, boolean strict, boolean abort) throws NonMonotonicSequenceException {
        int index;
        double previous = val[0];
        int max = val.length;
        block4: for (index = 1; index < max; ++index) {
            switch (dir) {
                case INCREASING: {
                    if (!(strict ? val[index] <= previous : val[index] < previous)) break;
                    break block4;
                }
                case DECREASING: {
                    if (!(strict ? val[index] >= previous : val[index] > previous)) break;
                    break block4;
                }
                default: {
                    throw new MathInternalError();
                }
            }
            previous = val[index];
        }
        if (index == max) {
            return true;
        }
        if (abort) {
            throw new NonMonotonicSequenceException(val[index], (Number)previous, index, dir, strict);
        }
        return false;
    }

    public static void checkOrder(double[] val, OrderDirection dir, boolean strict) throws NonMonotonicSequenceException {
        MathArrays.checkOrder(val, dir, strict, true);
    }

    public static void checkOrder(double[] val) throws NonMonotonicSequenceException {
        MathArrays.checkOrder(val, OrderDirection.INCREASING, true);
    }

    public static void checkRectangular(long[][] in) throws NullArgumentException, DimensionMismatchException {
        MathUtils.checkNotNull(in);
        for (int i2 = 1; i2 < in.length; ++i2) {
            if (in[i2].length == in[0].length) continue;
            throw new DimensionMismatchException((Localizable)LocalizedFormats.DIFFERENT_ROWS_LENGTHS, in[i2].length, in[0].length);
        }
    }

    public static void checkPositive(double[] in) throws NotStrictlyPositiveException {
        for (int i2 = 0; i2 < in.length; ++i2) {
            if (!(in[i2] <= 0.0)) continue;
            throw new NotStrictlyPositiveException(in[i2]);
        }
    }

    public static void checkNotNaN(double[] in) throws NotANumberException {
        for (int i2 = 0; i2 < in.length; ++i2) {
            if (!Double.isNaN(in[i2])) continue;
            throw new NotANumberException();
        }
    }

    public static void checkNonNegative(long[] in) throws NotPositiveException {
        for (int i2 = 0; i2 < in.length; ++i2) {
            if (in[i2] >= 0L) continue;
            throw new NotPositiveException(in[i2]);
        }
    }

    public static void checkNonNegative(long[][] in) throws NotPositiveException {
        for (int i2 = 0; i2 < in.length; ++i2) {
            for (int j2 = 0; j2 < in[i2].length; ++j2) {
                if (in[i2][j2] >= 0L) continue;
                throw new NotPositiveException(in[i2][j2]);
            }
        }
    }

    public static double safeNorm(double[] v2) {
        double rdwarf = 3.834E-20;
        double rgiant = 1.304E19;
        double s1 = 0.0;
        double s2 = 0.0;
        double s3 = 0.0;
        double x1max = 0.0;
        double x3max = 0.0;
        double floatn = v2.length;
        double agiant = rgiant / floatn;
        for (int i2 = 0; i2 < v2.length; ++i2) {
            double xabs = FastMath.abs(v2[i2]);
            if (xabs < rdwarf || xabs > agiant) {
                double r2;
                if (xabs > rdwarf) {
                    if (xabs > x1max) {
                        r2 = x1max / xabs;
                        s1 = 1.0 + s1 * r2 * r2;
                        x1max = xabs;
                        continue;
                    }
                    r2 = xabs / x1max;
                    s1 += r2 * r2;
                    continue;
                }
                if (xabs > x3max) {
                    r2 = x3max / xabs;
                    s3 = 1.0 + s3 * r2 * r2;
                    x3max = xabs;
                    continue;
                }
                if (xabs == 0.0) continue;
                r2 = xabs / x3max;
                s3 += r2 * r2;
                continue;
            }
            s2 += xabs * xabs;
        }
        double norm = s1 != 0.0 ? x1max * Math.sqrt(s1 + s2 / x1max / x1max) : (s2 == 0.0 ? x3max * Math.sqrt(s3) : (s2 >= x3max ? Math.sqrt(s2 * (1.0 + x3max / s2 * (x3max * s3))) : Math.sqrt(x3max * (s2 / x3max + x3max * s3))));
        return norm;
    }

    public static void sortInPlace(double[] x2, double[] ... yList) throws DimensionMismatchException, NullArgumentException {
        MathArrays.sortInPlace(x2, OrderDirection.INCREASING, yList);
    }

    public static void sortInPlace(double[] x2, OrderDirection dir, double[] ... yList) throws NullArgumentException, DimensionMismatchException {
        if (x2 == null) {
            throw new NullArgumentException();
        }
        int yListLen = yList.length;
        int len = x2.length;
        for (int j2 = 0; j2 < yListLen; ++j2) {
            double[] y2 = yList[j2];
            if (y2 == null) {
                throw new NullArgumentException();
            }
            if (y2.length == len) continue;
            throw new DimensionMismatchException(y2.length, len);
        }
        ArrayList<PairDoubleInteger> list = new ArrayList<PairDoubleInteger>(len);
        for (int i2 = 0; i2 < len; ++i2) {
            list.add(new PairDoubleInteger(x2[i2], i2));
        }
        Comparator<PairDoubleInteger> comp = dir == OrderDirection.INCREASING ? new Comparator<PairDoubleInteger>(){

            @Override
            public int compare(PairDoubleInteger o1, PairDoubleInteger o2) {
                return Double.compare(o1.getKey(), o2.getKey());
            }
        } : new Comparator<PairDoubleInteger>(){

            @Override
            public int compare(PairDoubleInteger o1, PairDoubleInteger o2) {
                return Double.compare(o2.getKey(), o1.getKey());
            }
        };
        Collections.sort(list, comp);
        int[] indices = new int[len];
        for (int i3 = 0; i3 < len; ++i3) {
            PairDoubleInteger e2 = (PairDoubleInteger)list.get(i3);
            x2[i3] = e2.getKey();
            indices[i3] = e2.getValue();
        }
        for (int j3 = 0; j3 < yListLen; ++j3) {
            double[] yInPlace = yList[j3];
            double[] yOrig = (double[])yInPlace.clone();
            for (int i4 = 0; i4 < len; ++i4) {
                yInPlace[i4] = yOrig[indices[i4]];
            }
        }
    }

    public static int[] copyOf(int[] source) {
        return MathArrays.copyOf(source, source.length);
    }

    public static double[] copyOf(double[] source) {
        return MathArrays.copyOf(source, source.length);
    }

    public static int[] copyOf(int[] source, int len) {
        int[] output = new int[len];
        System.arraycopy(source, 0, output, 0, FastMath.min(len, source.length));
        return output;
    }

    public static double[] copyOf(double[] source, int len) {
        double[] output = new double[len];
        System.arraycopy(source, 0, output, 0, FastMath.min(len, source.length));
        return output;
    }

    public static double[] copyOfRange(double[] source, int from, int to) {
        int len = to - from;
        double[] output = new double[len];
        System.arraycopy(source, from, output, 0, FastMath.min(len, source.length - from));
        return output;
    }

    public static double linearCombination(double[] a2, double[] b2) throws DimensionMismatchException {
        MathArrays.checkEqualLength(a2, b2);
        int len = a2.length;
        if (len == 1) {
            return a2[0] * b2[0];
        }
        double[] prodHigh = new double[len];
        double prodLowSum = 0.0;
        for (int i2 = 0; i2 < len; ++i2) {
            double ai = a2[i2];
            double aHigh = Double.longBitsToDouble(Double.doubleToRawLongBits(ai) & 0xFFFFFFFFF8000000L);
            double aLow = ai - aHigh;
            double bi = b2[i2];
            double bHigh = Double.longBitsToDouble(Double.doubleToRawLongBits(bi) & 0xFFFFFFFFF8000000L);
            double bLow = bi - bHigh;
            prodHigh[i2] = ai * bi;
            double prodLow = aLow * bLow - (prodHigh[i2] - aHigh * bHigh - aLow * bHigh - aHigh * bLow);
            prodLowSum += prodLow;
        }
        double prodHighCur = prodHigh[0];
        double prodHighNext = prodHigh[1];
        double sHighPrev = prodHighCur + prodHighNext;
        double sPrime = sHighPrev - prodHighNext;
        double sLowSum = prodHighNext - (sHighPrev - sPrime) + (prodHighCur - sPrime);
        int lenMinusOne = len - 1;
        for (int i3 = 1; i3 < lenMinusOne; ++i3) {
            prodHighNext = prodHigh[i3 + 1];
            double sHighCur = sHighPrev + prodHighNext;
            sPrime = sHighCur - prodHighNext;
            sLowSum += prodHighNext - (sHighCur - sPrime) + (sHighPrev - sPrime);
            sHighPrev = sHighCur;
        }
        double result = sHighPrev + (prodLowSum + sLowSum);
        if (Double.isNaN(result)) {
            result = 0.0;
            for (int i4 = 0; i4 < len; ++i4) {
                result += a2[i4] * b2[i4];
            }
        }
        return result;
    }

    public static double linearCombination(double a1, double b1, double a2, double b2) {
        double s12Prime;
        double s12Low;
        double b2High;
        double b2Low;
        double a2High;
        double a2Low;
        double prod2Low;
        double b1High;
        double b1Low;
        double prod1High = a1 * b1;
        double prod2High = a2 * b2;
        double s12High = prod1High + prod2High;
        double a1High = Double.longBitsToDouble(Double.doubleToRawLongBits(a1) & 0xFFFFFFFFF8000000L);
        double a1Low = a1 - a1High;
        double prod1Low = a1Low * (b1Low = b1 - (b1High = Double.longBitsToDouble(Double.doubleToRawLongBits(b1) & 0xFFFFFFFFF8000000L))) - (prod1High - a1High * b1High - a1Low * b1High - a1High * b1Low);
        double result = s12High + (prod1Low + (prod2Low = (a2Low = a2 - (a2High = Double.longBitsToDouble(Double.doubleToRawLongBits(a2) & 0xFFFFFFFFF8000000L))) * (b2Low = b2 - (b2High = Double.longBitsToDouble(Double.doubleToRawLongBits(b2) & 0xFFFFFFFFF8000000L))) - (prod2High - a2High * b2High - a2Low * b2High - a2High * b2Low)) + (s12Low = prod2High - (s12High - (s12Prime = s12High - prod2High)) + (prod1High - s12Prime)));
        if (Double.isNaN(result)) {
            result = a1 * b1 + a2 * b2;
        }
        return result;
    }

    public static double linearCombination(double a1, double b1, double a2, double b2, double a3, double b3) {
        double s123Prime;
        double s123Low;
        double s12Prime;
        double s12Low;
        double b3High;
        double b3Low;
        double a3High;
        double a3Low;
        double prod3Low;
        double b2High;
        double b2Low;
        double a2High;
        double a2Low;
        double prod2Low;
        double b1High;
        double b1Low;
        double prod1High = a1 * b1;
        double prod2High = a2 * b2;
        double s12High = prod1High + prod2High;
        double prod3High = a3 * b3;
        double s123High = s12High + prod3High;
        double a1High = Double.longBitsToDouble(Double.doubleToRawLongBits(a1) & 0xFFFFFFFFF8000000L);
        double a1Low = a1 - a1High;
        double prod1Low = a1Low * (b1Low = b1 - (b1High = Double.longBitsToDouble(Double.doubleToRawLongBits(b1) & 0xFFFFFFFFF8000000L))) - (prod1High - a1High * b1High - a1Low * b1High - a1High * b1Low);
        double result = s123High + (prod1Low + (prod2Low = (a2Low = a2 - (a2High = Double.longBitsToDouble(Double.doubleToRawLongBits(a2) & 0xFFFFFFFFF8000000L))) * (b2Low = b2 - (b2High = Double.longBitsToDouble(Double.doubleToRawLongBits(b2) & 0xFFFFFFFFF8000000L))) - (prod2High - a2High * b2High - a2Low * b2High - a2High * b2Low)) + (prod3Low = (a3Low = a3 - (a3High = Double.longBitsToDouble(Double.doubleToRawLongBits(a3) & 0xFFFFFFFFF8000000L))) * (b3Low = b3 - (b3High = Double.longBitsToDouble(Double.doubleToRawLongBits(b3) & 0xFFFFFFFFF8000000L))) - (prod3High - a3High * b3High - a3Low * b3High - a3High * b3Low)) + (s12Low = prod2High - (s12High - (s12Prime = s12High - prod2High)) + (prod1High - s12Prime)) + (s123Low = prod3High - (s123High - (s123Prime = s123High - prod3High)) + (s12High - s123Prime)));
        if (Double.isNaN(result)) {
            result = a1 * b1 + a2 * b2 + a3 * b3;
        }
        return result;
    }

    public static double linearCombination(double a1, double b1, double a2, double b2, double a3, double b3, double a4, double b4) {
        double s1234Prime;
        double s1234Low;
        double s123Prime;
        double s123Low;
        double s12Prime;
        double s12Low;
        double b4High;
        double b4Low;
        double a4High;
        double a4Low;
        double prod4Low;
        double b3High;
        double b3Low;
        double a3High;
        double a3Low;
        double prod3Low;
        double b2High;
        double b2Low;
        double a2High;
        double a2Low;
        double prod2Low;
        double b1High;
        double b1Low;
        double prod1High = a1 * b1;
        double prod2High = a2 * b2;
        double s12High = prod1High + prod2High;
        double prod3High = a3 * b3;
        double s123High = s12High + prod3High;
        double prod4High = a4 * b4;
        double s1234High = s123High + prod4High;
        double a1High = Double.longBitsToDouble(Double.doubleToRawLongBits(a1) & 0xFFFFFFFFF8000000L);
        double a1Low = a1 - a1High;
        double prod1Low = a1Low * (b1Low = b1 - (b1High = Double.longBitsToDouble(Double.doubleToRawLongBits(b1) & 0xFFFFFFFFF8000000L))) - (prod1High - a1High * b1High - a1Low * b1High - a1High * b1Low);
        double result = s1234High + (prod1Low + (prod2Low = (a2Low = a2 - (a2High = Double.longBitsToDouble(Double.doubleToRawLongBits(a2) & 0xFFFFFFFFF8000000L))) * (b2Low = b2 - (b2High = Double.longBitsToDouble(Double.doubleToRawLongBits(b2) & 0xFFFFFFFFF8000000L))) - (prod2High - a2High * b2High - a2Low * b2High - a2High * b2Low)) + (prod3Low = (a3Low = a3 - (a3High = Double.longBitsToDouble(Double.doubleToRawLongBits(a3) & 0xFFFFFFFFF8000000L))) * (b3Low = b3 - (b3High = Double.longBitsToDouble(Double.doubleToRawLongBits(b3) & 0xFFFFFFFFF8000000L))) - (prod3High - a3High * b3High - a3Low * b3High - a3High * b3Low)) + (prod4Low = (a4Low = a4 - (a4High = Double.longBitsToDouble(Double.doubleToRawLongBits(a4) & 0xFFFFFFFFF8000000L))) * (b4Low = b4 - (b4High = Double.longBitsToDouble(Double.doubleToRawLongBits(b4) & 0xFFFFFFFFF8000000L))) - (prod4High - a4High * b4High - a4Low * b4High - a4High * b4Low)) + (s12Low = prod2High - (s12High - (s12Prime = s12High - prod2High)) + (prod1High - s12Prime)) + (s123Low = prod3High - (s123High - (s123Prime = s123High - prod3High)) + (s12High - s123Prime)) + (s1234Low = prod4High - (s1234High - (s1234Prime = s1234High - prod4High)) + (s123High - s1234Prime)));
        if (Double.isNaN(result)) {
            result = a1 * b1 + a2 * b2 + a3 * b3 + a4 * b4;
        }
        return result;
    }

    public static boolean equals(float[] x2, float[] y2) {
        if (x2 == null || y2 == null) {
            return !(x2 == null ^ y2 == null);
        }
        if (x2.length != y2.length) {
            return false;
        }
        for (int i2 = 0; i2 < x2.length; ++i2) {
            if (Precision.equals(x2[i2], y2[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIncludingNaN(float[] x2, float[] y2) {
        if (x2 == null || y2 == null) {
            return !(x2 == null ^ y2 == null);
        }
        if (x2.length != y2.length) {
            return false;
        }
        for (int i2 = 0; i2 < x2.length; ++i2) {
            if (Precision.equalsIncludingNaN(x2[i2], y2[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(double[] x2, double[] y2) {
        if (x2 == null || y2 == null) {
            return !(x2 == null ^ y2 == null);
        }
        if (x2.length != y2.length) {
            return false;
        }
        for (int i2 = 0; i2 < x2.length; ++i2) {
            if (Precision.equals(x2[i2], y2[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIncludingNaN(double[] x2, double[] y2) {
        if (x2 == null || y2 == null) {
            return !(x2 == null ^ y2 == null);
        }
        if (x2.length != y2.length) {
            return false;
        }
        for (int i2 = 0; i2 < x2.length; ++i2) {
            if (Precision.equalsIncludingNaN(x2[i2], y2[i2])) continue;
            return false;
        }
        return true;
    }

    public static double[] normalizeArray(double[] values, double normalizedSum) throws MathIllegalArgumentException, MathArithmeticException {
        int i2;
        if (Double.isInfinite(normalizedSum)) {
            throw new MathIllegalArgumentException(LocalizedFormats.NORMALIZE_INFINITE, new Object[0]);
        }
        if (Double.isNaN(normalizedSum)) {
            throw new MathIllegalArgumentException(LocalizedFormats.NORMALIZE_NAN, new Object[0]);
        }
        double sum = 0.0;
        int len = values.length;
        double[] out = new double[len];
        for (i2 = 0; i2 < len; ++i2) {
            if (Double.isInfinite(values[i2])) {
                throw new MathIllegalArgumentException(LocalizedFormats.INFINITE_ARRAY_ELEMENT, values[i2], i2);
            }
            if (Double.isNaN(values[i2])) continue;
            sum += values[i2];
        }
        if (sum == 0.0) {
            throw new MathArithmeticException(LocalizedFormats.ARRAY_SUMS_TO_ZERO, new Object[0]);
        }
        for (i2 = 0; i2 < len; ++i2) {
            out[i2] = Double.isNaN(values[i2]) ? Double.NaN : values[i2] * normalizedSum / sum;
        }
        return out;
    }

    public static <T> T[] buildArray(Field<T> field, int length) {
        Object[] array = (Object[])Array.newInstance(field.getRuntimeClass(), length);
        Arrays.fill(array, field.getZero());
        return array;
    }

    public static <T> T[][] buildArray(Field<T> field, int rows, int columns) {
        Object[][] array;
        if (columns < 0) {
            T[] dummyRow = MathArrays.buildArray(field, 0);
            array = (Object[][])Array.newInstance(dummyRow.getClass(), rows);
        } else {
            array = (Object[][])Array.newInstance(field.getRuntimeClass(), rows, columns);
            for (int i2 = 0; i2 < rows; ++i2) {
                Arrays.fill(array[i2], field.getZero());
            }
        }
        return array;
    }

    public static double[] convolve(double[] x2, double[] h2) throws NullArgumentException, NoDataException {
        MathUtils.checkNotNull(x2);
        MathUtils.checkNotNull(h2);
        int xLen = x2.length;
        int hLen = h2.length;
        if (xLen == 0 || hLen == 0) {
            throw new NoDataException();
        }
        int totalLength = xLen + hLen - 1;
        double[] y2 = new double[totalLength];
        for (int n2 = 0; n2 < totalLength; ++n2) {
            double yn = 0.0;
            int k2 = FastMath.max(0, n2 + 1 - xLen);
            int j2 = n2 - k2;
            while (k2 < hLen && j2 >= 0) {
                yn += x2[j2--] * h2[k2++];
            }
            y2[n2] = yn;
        }
        return y2;
    }

    public static void shuffle(int[] list, int start, Position pos) {
        MathArrays.shuffle(list, start, pos, new Well19937c());
    }

    public static void shuffle(int[] list, int start, Position pos, RandomGenerator rng) {
        switch (pos) {
            case TAIL: {
                for (int i2 = list.length - 1; i2 >= start; --i2) {
                    int target = i2 == start ? start : new UniformIntegerDistribution(rng, start, i2).sample();
                    int temp = list[target];
                    list[target] = list[i2];
                    list[i2] = temp;
                }
                break;
            }
            case HEAD: {
                for (int i3 = 0; i3 <= start; ++i3) {
                    int target = i3 == start ? start : new UniformIntegerDistribution(rng, i3, start).sample();
                    int temp = list[target];
                    list[target] = list[i3];
                    list[i3] = temp;
                }
                break;
            }
            default: {
                throw new MathInternalError();
            }
        }
    }

    public static void shuffle(int[] list, RandomGenerator rng) {
        MathArrays.shuffle(list, 0, Position.TAIL, rng);
    }

    public static void shuffle(int[] list) {
        MathArrays.shuffle(list, new Well19937c());
    }

    public static int[] natural(int n2) {
        return MathArrays.sequence(n2, 0, 1);
    }

    public static int[] sequence(int size, int start, int stride) {
        int[] a2 = new int[size];
        for (int i2 = 0; i2 < size; ++i2) {
            a2[i2] = start + i2 * stride;
        }
        return a2;
    }

    public static boolean verifyValues(double[] values, int begin, int length) throws MathIllegalArgumentException {
        return MathArrays.verifyValues(values, begin, length, false);
    }

    public static boolean verifyValues(double[] values, int begin, int length, boolean allowEmpty) throws MathIllegalArgumentException {
        if (values == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        if (begin < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.START_POSITION, begin);
        }
        if (length < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.LENGTH, length);
        }
        if (begin + length > values.length) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.SUBARRAY_ENDS_AFTER_ARRAY_END, (Number)(begin + length), values.length, true);
        }
        return length != 0 || allowEmpty;
    }

    public static boolean verifyValues(double[] values, double[] weights, int begin, int length) throws MathIllegalArgumentException {
        return MathArrays.verifyValues(values, weights, begin, length, false);
    }

    public static boolean verifyValues(double[] values, double[] weights, int begin, int length, boolean allowEmpty) throws MathIllegalArgumentException {
        if (weights == null || values == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        MathArrays.checkEqualLength(weights, values);
        boolean containsPositiveWeight = false;
        for (int i2 = begin; i2 < begin + length; ++i2) {
            double weight = weights[i2];
            if (Double.isNaN(weight)) {
                throw new MathIllegalArgumentException(LocalizedFormats.NAN_ELEMENT_AT_INDEX, i2);
            }
            if (Double.isInfinite(weight)) {
                throw new MathIllegalArgumentException(LocalizedFormats.INFINITE_ARRAY_ELEMENT, weight, i2);
            }
            if (weight < 0.0) {
                throw new MathIllegalArgumentException(LocalizedFormats.NEGATIVE_ELEMENT_AT_INDEX, i2, weight);
            }
            if (containsPositiveWeight || !(weight > 0.0)) continue;
            containsPositiveWeight = true;
        }
        if (!containsPositiveWeight) {
            throw new MathIllegalArgumentException(LocalizedFormats.WEIGHT_AT_LEAST_ONE_NON_ZERO, new Object[0]);
        }
        return MathArrays.verifyValues(values, begin, length, allowEmpty);
    }

    public static double[] concatenate(double[] ... x2) {
        int combinedLength = 0;
        for (double[] a2 : x2) {
            combinedLength += a2.length;
        }
        int offset = 0;
        int curLength = 0;
        double[] combined = new double[combinedLength];
        for (int i2 = 0; i2 < x2.length; ++i2) {
            curLength = x2[i2].length;
            System.arraycopy(x2[i2], 0, combined, offset, curLength);
            offset += curLength;
        }
        return combined;
    }

    public static double[] unique(double[] data) {
        TreeSet<Double> values = new TreeSet<Double>();
        for (int i2 = 0; i2 < data.length; ++i2) {
            values.add(data[i2]);
        }
        int count = values.size();
        double[] out = new double[count];
        Iterator iterator = values.iterator();
        int i3 = 0;
        while (iterator.hasNext()) {
            out[count - ++i3] = (Double)iterator.next();
        }
        return out;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Position {
        HEAD,
        TAIL;

    }

    private static class PairDoubleInteger {
        private final double key;
        private final int value;

        PairDoubleInteger(double key, int value) {
            this.key = key;
            this.value = value;
        }

        public double getKey() {
            return this.key;
        }

        public int getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OrderDirection {
        INCREASING,
        DECREASING;

    }

    public static interface Function {
        public double evaluate(double[] var1);

        public double evaluate(double[] var1, int var2, int var3);
    }
}

