/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

public class CompositeFormat {
    private CompositeFormat() {
    }

    public static NumberFormat getDefaultNumberFormat() {
        return CompositeFormat.getDefaultNumberFormat(Locale.getDefault());
    }

    public static NumberFormat getDefaultNumberFormat(Locale locale) {
        NumberFormat nf = NumberFormat.getInstance(locale);
        nf.setMaximumFractionDigits(10);
        return nf;
    }

    public static void parseAndIgnoreWhitespace(String source, ParsePosition pos) {
        CompositeFormat.parseNextCharacter(source, pos);
        pos.setIndex(pos.getIndex() - 1);
    }

    public static char parseNextCharacter(String source, ParsePosition pos) {
        int index = pos.getIndex();
        int n2 = source.length();
        char ret = '\u0000';
        if (index < n2) {
            char c2;
            while (Character.isWhitespace(c2 = source.charAt(index++)) && index < n2) {
            }
            pos.setIndex(index);
            if (index < n2) {
                ret = c2;
            }
        }
        return ret;
    }

    private static Number parseNumber(String source, double value, ParsePosition pos) {
        Double ret = null;
        StringBuilder sb2 = new StringBuilder();
        sb2.append('(');
        sb2.append(value);
        sb2.append(')');
        int n2 = sb2.length();
        int startIndex = pos.getIndex();
        int endIndex = startIndex + n2;
        if (endIndex < source.length() && source.substring(startIndex, endIndex).compareTo(sb2.toString()) == 0) {
            ret = value;
            pos.setIndex(endIndex);
        }
        return ret;
    }

    public static Number parseNumber(String source, NumberFormat format, ParsePosition pos) {
        int startIndex = pos.getIndex();
        Number number = format.parse(source, pos);
        int endIndex = pos.getIndex();
        if (startIndex == endIndex) {
            double[] special = new double[]{Double.NaN, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
            for (int i2 = 0; i2 < special.length && (number = CompositeFormat.parseNumber(source, special[i2], pos)) == null; ++i2) {
            }
        }
        return number;
    }

    public static boolean parseFixedstring(String source, String expected, ParsePosition pos) {
        int startIndex = pos.getIndex();
        int endIndex = startIndex + expected.length();
        if (startIndex >= source.length() || endIndex > source.length() || source.substring(startIndex, endIndex).compareTo(expected) != 0) {
            pos.setIndex(startIndex);
            pos.setErrorIndex(startIndex);
            return false;
        }
        pos.setIndex(endIndex);
        return true;
    }

    public static StringBuffer formatDouble(double value, NumberFormat format, StringBuffer toAppendTo, FieldPosition pos) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            toAppendTo.append('(');
            toAppendTo.append(value);
            toAppendTo.append(')');
        } else {
            format.format(value, toAppendTo, pos);
        }
        return toAppendTo;
    }
}

