/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.inference;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.distribution.EnumeratedRealDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.apache.commons.math3.exception.InsufficientDataException;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.MathInternalError;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.TooManyIterationsException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.fraction.BigFraction;
import org.apache.commons.math3.fraction.BigFractionField;
import org.apache.commons.math3.fraction.FractionConversionException;
import org.apache.commons.math3.linear.Array2DRowFieldMatrix;
import org.apache.commons.math3.linear.FieldMatrix;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.random.JDKRandomGenerator;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.util.CombinatoricsUtils;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KolmogorovSmirnovTest {
    protected static final int MAXIMUM_PARTIAL_SUM_COUNT = 100000;
    protected static final double KS_SUM_CAUCHY_CRITERION = 1.0E-20;
    protected static final double PG_SUM_RELATIVE_ERROR = 1.0E-10;
    @Deprecated
    protected static final int SMALL_SAMPLE_PRODUCT = 200;
    protected static final int LARGE_SAMPLE_PRODUCT = 10000;
    @Deprecated
    protected static final int MONTE_CARLO_ITERATIONS = 1000000;
    private final RandomGenerator rng;

    public KolmogorovSmirnovTest() {
        this.rng = new Well19937c();
    }

    @Deprecated
    public KolmogorovSmirnovTest(RandomGenerator rng) {
        this.rng = rng;
    }

    public double kolmogorovSmirnovTest(RealDistribution distribution, double[] data, boolean exact) {
        return 1.0 - this.cdf(this.kolmogorovSmirnovStatistic(distribution, data), data.length, exact);
    }

    public double kolmogorovSmirnovStatistic(RealDistribution distribution, double[] data) {
        this.checkArray(data);
        int n2 = data.length;
        double nd2 = n2;
        double[] dataCopy = new double[n2];
        System.arraycopy(data, 0, dataCopy, 0, n2);
        Arrays.sort(dataCopy);
        double d2 = 0.0;
        for (int i2 = 1; i2 <= n2; ++i2) {
            double yi = distribution.cumulativeProbability(dataCopy[i2 - 1]);
            double currD = FastMath.max(yi - (double)(i2 - 1) / nd2, (double)i2 / nd2 - yi);
            if (!(currD > d2)) continue;
            d2 = currD;
        }
        return d2;
    }

    public double kolmogorovSmirnovTest(double[] x2, double[] y2, boolean strict) {
        long lengthProduct = (long)x2.length * (long)y2.length;
        double[] xa = null;
        double[] ya = null;
        if (lengthProduct < 10000L && KolmogorovSmirnovTest.hasTies(x2, y2)) {
            xa = MathArrays.copyOf(x2);
            ya = MathArrays.copyOf(y2);
            KolmogorovSmirnovTest.fixTies(xa, ya);
        } else {
            xa = x2;
            ya = y2;
        }
        if (lengthProduct < 10000L) {
            return this.exactP(this.kolmogorovSmirnovStatistic(xa, ya), x2.length, y2.length, strict);
        }
        return this.approximateP(this.kolmogorovSmirnovStatistic(x2, y2), x2.length, y2.length);
    }

    public double kolmogorovSmirnovTest(double[] x2, double[] y2) {
        return this.kolmogorovSmirnovTest(x2, y2, true);
    }

    public double kolmogorovSmirnovStatistic(double[] x2, double[] y2) {
        return (double)this.integralKolmogorovSmirnovStatistic(x2, y2) / (double)((long)x2.length * (long)y2.length);
    }

    private long integralKolmogorovSmirnovStatistic(double[] x2, double[] y2) {
        this.checkArray(x2);
        this.checkArray(y2);
        double[] sx = MathArrays.copyOf(x2);
        double[] sy = MathArrays.copyOf(y2);
        Arrays.sort(sx);
        Arrays.sort(sy);
        int n2 = sx.length;
        int m2 = sy.length;
        int rankX = 0;
        int rankY = 0;
        long curD = 0L;
        long supD = 0L;
        do {
            double z2;
            double d2 = z2 = Double.compare(sx[rankX], sy[rankY]) <= 0 ? sx[rankX] : sy[rankY];
            while (rankX < n2 && Double.compare(sx[rankX], z2) == 0) {
                ++rankX;
                curD += (long)m2;
            }
            while (rankY < m2 && Double.compare(sy[rankY], z2) == 0) {
                ++rankY;
                curD -= (long)n2;
            }
            if (curD > supD) {
                supD = curD;
                continue;
            }
            if (-curD <= supD) continue;
            supD = -curD;
        } while (rankX < n2 && rankY < m2);
        return supD;
    }

    public double kolmogorovSmirnovTest(RealDistribution distribution, double[] data) {
        return this.kolmogorovSmirnovTest(distribution, data, false);
    }

    public boolean kolmogorovSmirnovTest(RealDistribution distribution, double[] data, double alpha) {
        if (alpha <= 0.0 || alpha > 0.5) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_BOUND_SIGNIFICANCE_LEVEL, (Number)alpha, 0, 0.5);
        }
        return this.kolmogorovSmirnovTest(distribution, data) < alpha;
    }

    public double bootstrap(double[] x2, double[] y2, int iterations, boolean strict) {
        int xLength = x2.length;
        int yLength = y2.length;
        double[] combined = new double[xLength + yLength];
        System.arraycopy(x2, 0, combined, 0, xLength);
        System.arraycopy(y2, 0, combined, xLength, yLength);
        EnumeratedRealDistribution dist = new EnumeratedRealDistribution(this.rng, combined);
        long d2 = this.integralKolmogorovSmirnovStatistic(x2, y2);
        int greaterCount = 0;
        int equalCount = 0;
        for (int i2 = 0; i2 < iterations; ++i2) {
            double[] curY;
            double[] curX = dist.sample(xLength);
            long curD = this.integralKolmogorovSmirnovStatistic(curX, curY = dist.sample(yLength));
            if (curD > d2) {
                ++greaterCount;
                continue;
            }
            if (curD != d2) continue;
            ++equalCount;
        }
        return strict ? (double)greaterCount / (double)iterations : (double)(greaterCount + equalCount) / (double)iterations;
    }

    public double bootstrap(double[] x2, double[] y2, int iterations) {
        return this.bootstrap(x2, y2, iterations, true);
    }

    public double cdf(double d2, int n2) throws MathArithmeticException {
        return this.cdf(d2, n2, false);
    }

    public double cdfExact(double d2, int n2) throws MathArithmeticException {
        return this.cdf(d2, n2, true);
    }

    public double cdf(double d2, int n2, boolean exact) throws MathArithmeticException {
        double ninv = 1.0 / (double)n2;
        double ninvhalf = 0.5 * ninv;
        if (d2 <= ninvhalf) {
            return 0.0;
        }
        if (ninvhalf < d2 && d2 <= ninv) {
            double res = 1.0;
            double f2 = 2.0 * d2 - ninv;
            for (int i2 = 1; i2 <= n2; ++i2) {
                res *= (double)i2 * f2;
            }
            return res;
        }
        if (1.0 - ninv <= d2 && d2 < 1.0) {
            return 1.0 - 2.0 * Math.pow(1.0 - d2, n2);
        }
        if (1.0 <= d2) {
            return 1.0;
        }
        if (exact) {
            return this.exactK(d2, n2);
        }
        if (n2 <= 140) {
            return this.roundedK(d2, n2);
        }
        return this.pelzGood(d2, n2);
    }

    private double exactK(double d2, int n2) throws MathArithmeticException {
        int k2 = (int)Math.ceil((double)n2 * d2);
        FieldMatrix<BigFraction> H = this.createExactH(d2, n2);
        FieldMatrix<BigFraction> Hpower = H.power(n2);
        BigFraction pFrac = Hpower.getEntry(k2 - 1, k2 - 1);
        for (int i2 = 1; i2 <= n2; ++i2) {
            pFrac = pFrac.multiply(i2).divide(n2);
        }
        return pFrac.bigDecimalValue(20, 4).doubleValue();
    }

    private double roundedK(double d2, int n2) {
        int k2 = (int)Math.ceil((double)n2 * d2);
        RealMatrix H = this.createRoundedH(d2, n2);
        RealMatrix Hpower = H.power(n2);
        double pFrac = Hpower.getEntry(k2 - 1, k2 - 1);
        for (int i2 = 1; i2 <= n2; ++i2) {
            pFrac *= (double)i2 / (double)n2;
        }
        return pFrac;
    }

    public double pelzGood(double d2, int n2) {
        int k2;
        double sqrtN = FastMath.sqrt(n2);
        double z2 = d2 * sqrtN;
        double z22 = d2 * d2 * (double)n2;
        double z4 = z22 * z22;
        double z6 = z4 * z22;
        double z8 = z4 * z4;
        double ret = 0.0;
        double sum = 0.0;
        double increment = 0.0;
        double kTerm = 0.0;
        double z2Term = Math.PI * Math.PI / (8.0 * z22);
        for (k2 = 1; k2 < 100000 && !((increment = FastMath.exp(-z2Term * (kTerm = (double)(2 * k2 - 1)) * kTerm)) <= 1.0E-10 * (sum += increment)); ++k2) {
        }
        if (k2 == 100000) {
            throw new TooManyIterationsException(100000);
        }
        ret = sum * FastMath.sqrt(Math.PI * 2) / z2;
        double twoZ2 = 2.0 * z22;
        sum = 0.0;
        kTerm = 0.0;
        double kTerm2 = 0.0;
        for (k2 = 0; k2 < 100000; ++k2) {
            kTerm = (double)k2 + 0.5;
            kTerm2 = kTerm * kTerm;
            increment = (Math.PI * Math.PI * kTerm2 - z22) * FastMath.exp(-9.869604401089358 * kTerm2 / twoZ2);
            if (FastMath.abs(increment) < 1.0E-10 * FastMath.abs(sum += increment)) break;
        }
        if (k2 == 100000) {
            throw new TooManyIterationsException(100000);
        }
        double sqrtHalfPi = FastMath.sqrt(1.5707963267948966);
        ret += sum * sqrtHalfPi / (3.0 * z4 * sqrtN);
        double z4Term = 2.0 * z4;
        double z6Term = 6.0 * z6;
        z2Term = 5.0 * z22;
        double pi4 = 97.40909103400243;
        sum = 0.0;
        kTerm = 0.0;
        kTerm2 = 0.0;
        for (k2 = 0; k2 < 100000; ++k2) {
            kTerm = (double)k2 + 0.5;
            kTerm2 = kTerm * kTerm;
            increment = (z6Term + z4Term + Math.PI * Math.PI * (z4Term - z2Term) * kTerm2 + 97.40909103400243 * (1.0 - twoZ2) * kTerm2 * kTerm2) * FastMath.exp(-9.869604401089358 * kTerm2 / twoZ2);
            if (FastMath.abs(increment) < 1.0E-10 * FastMath.abs(sum += increment)) break;
        }
        if (k2 == 100000) {
            throw new TooManyIterationsException(100000);
        }
        double sum2 = 0.0;
        kTerm2 = 0.0;
        for (k2 = 1; k2 < 100000; ++k2) {
            kTerm2 = k2 * k2;
            increment = Math.PI * Math.PI * kTerm2 * FastMath.exp(-9.869604401089358 * kTerm2 / twoZ2);
            if (FastMath.abs(increment) < 1.0E-10 * FastMath.abs(sum2 += increment)) break;
        }
        if (k2 == 100000) {
            throw new TooManyIterationsException(100000);
        }
        ret += sqrtHalfPi / (double)n2 * (sum / (36.0 * z22 * z22 * z22 * z2) - sum2 / (18.0 * z22 * z2));
        double pi6 = 961.3891935753043;
        sum = 0.0;
        double kTerm4 = 0.0;
        double kTerm6 = 0.0;
        for (k2 = 0; k2 < 100000; ++k2) {
            kTerm = (double)k2 + 0.5;
            kTerm2 = kTerm * kTerm;
            kTerm4 = kTerm2 * kTerm2;
            kTerm6 = kTerm4 * kTerm2;
            increment = (961.3891935753043 * kTerm6 * (5.0 - 30.0 * z22) + 97.40909103400243 * kTerm4 * (-60.0 * z22 + 212.0 * z4) + Math.PI * Math.PI * kTerm2 * (135.0 * z4 - 96.0 * z6) - 30.0 * z6 - 90.0 * z8) * FastMath.exp(-9.869604401089358 * kTerm2 / twoZ2);
            if (FastMath.abs(increment) < 1.0E-10 * FastMath.abs(sum += increment)) break;
        }
        if (k2 == 100000) {
            throw new TooManyIterationsException(100000);
        }
        sum2 = 0.0;
        for (k2 = 1; k2 < 100000; ++k2) {
            kTerm2 = k2 * k2;
            kTerm4 = kTerm2 * kTerm2;
            increment = (-97.40909103400243 * kTerm4 + 29.608813203268074 * kTerm2 * z22) * FastMath.exp(-9.869604401089358 * kTerm2 / twoZ2);
            if (FastMath.abs(increment) < 1.0E-10 * FastMath.abs(sum2 += increment)) break;
        }
        if (k2 == 100000) {
            throw new TooManyIterationsException(100000);
        }
        return ret + sqrtHalfPi / (sqrtN * (double)n2) * (sum / (3240.0 * z6 * z4) + sum2 / (108.0 * z6));
    }

    private FieldMatrix<BigFraction> createExactH(double d2, int n2) throws NumberIsTooLargeException, FractionConversionException {
        int i2;
        int k2 = (int)Math.ceil((double)n2 * d2);
        int m2 = 2 * k2 - 1;
        double hDouble = (double)k2 - (double)n2 * d2;
        if (hDouble >= 1.0) {
            throw new NumberIsTooLargeException(hDouble, (Number)1.0, false);
        }
        BigFraction h2 = null;
        try {
            h2 = new BigFraction(hDouble, 1.0E-20, 10000);
        }
        catch (FractionConversionException e1) {
            try {
                h2 = new BigFraction(hDouble, 1.0E-10, 10000);
            }
            catch (FractionConversionException e2) {
                h2 = new BigFraction(hDouble, 1.0E-5, 10000);
            }
        }
        FieldElement[][] Hdata = new BigFraction[m2][m2];
        for (int i3 = 0; i3 < m2; ++i3) {
            for (int j2 = 0; j2 < m2; ++j2) {
                Hdata[i3][j2] = i3 - j2 + 1 < 0 ? BigFraction.ZERO : BigFraction.ONE;
            }
        }
        BigFraction[] hPowers = new BigFraction[m2];
        hPowers[0] = h2;
        for (i2 = 1; i2 < m2; ++i2) {
            hPowers[i2] = h2.multiply(hPowers[i2 - 1]);
        }
        for (i2 = 0; i2 < m2; ++i2) {
            Hdata[i2][0] = Hdata[i2][0].subtract(hPowers[i2]);
            Hdata[m2 - 1][i2] = ((BigFraction)Hdata[m2 - 1][i2]).subtract(hPowers[m2 - i2 - 1]);
        }
        if (h2.compareTo(BigFraction.ONE_HALF) == 1) {
            Hdata[m2 - 1][0] = ((BigFraction)Hdata[m2 - 1][0]).add(h2.multiply(2).subtract(1).pow(m2));
        }
        for (i2 = 0; i2 < m2; ++i2) {
            for (int j3 = 0; j3 < i2 + 1; ++j3) {
                if (i2 - j3 + 1 <= 0) continue;
                for (int g2 = 2; g2 <= i2 - j3 + 1; ++g2) {
                    Hdata[i2][j3] = ((BigFraction)Hdata[i2][j3]).divide(g2);
                }
            }
        }
        return new Array2DRowFieldMatrix((Field)BigFractionField.getInstance(), Hdata);
    }

    private RealMatrix createRoundedH(double d2, int n2) throws NumberIsTooLargeException {
        int i2;
        int k2 = (int)Math.ceil((double)n2 * d2);
        int m2 = 2 * k2 - 1;
        double h2 = (double)k2 - (double)n2 * d2;
        if (h2 >= 1.0) {
            throw new NumberIsTooLargeException(h2, (Number)1.0, false);
        }
        double[][] Hdata = new double[m2][m2];
        for (int i3 = 0; i3 < m2; ++i3) {
            for (int j2 = 0; j2 < m2; ++j2) {
                Hdata[i3][j2] = i3 - j2 + 1 < 0 ? 0.0 : 1.0;
            }
        }
        double[] hPowers = new double[m2];
        hPowers[0] = h2;
        for (i2 = 1; i2 < m2; ++i2) {
            hPowers[i2] = h2 * hPowers[i2 - 1];
        }
        for (i2 = 0; i2 < m2; ++i2) {
            Hdata[i2][0] = Hdata[i2][0] - hPowers[i2];
            double[] dArray = Hdata[m2 - 1];
            int n3 = i2;
            dArray[n3] = dArray[n3] - hPowers[m2 - i2 - 1];
        }
        if (Double.compare(h2, 0.5) > 0) {
            double[] dArray = Hdata[m2 - 1];
            dArray[0] = dArray[0] + FastMath.pow(2.0 * h2 - 1.0, m2);
        }
        for (i2 = 0; i2 < m2; ++i2) {
            for (int j3 = 0; j3 < i2 + 1; ++j3) {
                if (i2 - j3 + 1 <= 0) continue;
                for (int g2 = 2; g2 <= i2 - j3 + 1; ++g2) {
                    double[] dArray = Hdata[i2];
                    int n4 = j3;
                    dArray[n4] = dArray[n4] / (double)g2;
                }
            }
        }
        return MatrixUtils.createRealMatrix(Hdata);
    }

    private void checkArray(double[] array) {
        if (array == null) {
            throw new NullArgumentException(LocalizedFormats.NULL_NOT_ALLOWED, new Object[0]);
        }
        if (array.length < 2) {
            throw new InsufficientDataException(LocalizedFormats.INSUFFICIENT_OBSERVED_POINTS_IN_SAMPLE, array.length, 2);
        }
    }

    public double ksSum(double t2, double tolerance, int maxIterations) {
        long i2;
        if (t2 == 0.0) {
            return 0.0;
        }
        double x2 = -2.0 * t2 * t2;
        int sign = -1;
        double partialSum = 0.5;
        double delta = 1.0;
        for (i2 = 1L; delta > tolerance && i2 < (long)maxIterations; ++i2) {
            delta = FastMath.exp(x2 * (double)i2 * (double)i2);
            partialSum += (double)sign * delta;
            sign *= -1;
        }
        if (i2 == (long)maxIterations) {
            throw new TooManyIterationsException(maxIterations);
        }
        return partialSum * 2.0;
    }

    private static long calculateIntegralD(double d2, int n2, int m2, boolean strict) {
        double tol = 1.0E-12;
        long nm = (long)n2 * (long)m2;
        long upperBound = (long)FastMath.ceil((d2 - 1.0E-12) * (double)nm);
        long lowerBound = (long)FastMath.floor((d2 + 1.0E-12) * (double)nm);
        if (strict && lowerBound == upperBound) {
            return upperBound + 1L;
        }
        return upperBound;
    }

    public double exactP(double d2, int n2, int m2, boolean strict) {
        return 1.0 - KolmogorovSmirnovTest.n(m2, n2, m2, n2, KolmogorovSmirnovTest.calculateIntegralD(d2, m2, n2, strict), strict) / CombinatoricsUtils.binomialCoefficientDouble(n2 + m2, m2);
    }

    public double approximateP(double d2, int n2, int m2) {
        double dm = m2;
        double dn = n2;
        return 1.0 - this.ksSum(d2 * FastMath.sqrt(dm * dn / (dm + dn)), 1.0E-20, 100000);
    }

    static void fillBooleanArrayRandomlyWithFixedNumberTrueValues(boolean[] b2, int numberOfTrueValues, RandomGenerator rng) {
        Arrays.fill(b2, true);
        for (int k2 = numberOfTrueValues; k2 < b2.length; ++k2) {
            b2[b2[r = rng.nextInt((int)(k2 + 1))] ? r : k2] = false;
        }
    }

    public double monteCarloP(double d2, int n2, int m2, boolean strict, int iterations) {
        return this.integralMonteCarloP(KolmogorovSmirnovTest.calculateIntegralD(d2, n2, m2, strict), n2, m2, iterations);
    }

    private double integralMonteCarloP(long d2, int n2, int m2, int iterations) {
        int nn = FastMath.max(n2, m2);
        int mm = FastMath.min(n2, m2);
        int sum = nn + mm;
        int tail = 0;
        boolean[] b2 = new boolean[sum];
        block0: for (int i2 = 0; i2 < iterations; ++i2) {
            KolmogorovSmirnovTest.fillBooleanArrayRandomlyWithFixedNumberTrueValues(b2, nn, this.rng);
            long curD = 0L;
            for (int j2 = 0; j2 < b2.length; ++j2) {
                if (b2[j2]) {
                    if ((curD += (long)mm) < d2) continue;
                    ++tail;
                    continue block0;
                }
                if ((curD -= (long)nn) > -d2) continue;
                ++tail;
                continue block0;
            }
        }
        return (double)tail / (double)iterations;
    }

    private static void fixTies(double[] x2, double[] y2) {
        double[] values = MathArrays.unique(MathArrays.concatenate(x2, y2));
        if (values.length == x2.length + y2.length) {
            return;
        }
        double minDelta = 1.0;
        double prev = values[0];
        double delta = 1.0;
        for (int i2 = 1; i2 < values.length; ++i2) {
            delta = prev - values[i2];
            if (delta < minDelta) {
                minDelta = delta;
            }
            prev = values[i2];
        }
        UniformRealDistribution dist = new UniformRealDistribution(new JDKRandomGenerator(100), -(minDelta /= 2.0), minDelta);
        int ct = 0;
        boolean ties = true;
        do {
            KolmogorovSmirnovTest.jitter(x2, dist);
            KolmogorovSmirnovTest.jitter(y2, dist);
        } while ((ties = KolmogorovSmirnovTest.hasTies(x2, y2)) && ++ct < 1000);
        if (ties) {
            throw new MathInternalError();
        }
    }

    private static boolean hasTies(double[] x2, double[] y2) {
        int i2;
        HashSet<Double> values = new HashSet<Double>();
        for (i2 = 0; i2 < x2.length; ++i2) {
            if (values.add(x2[i2])) continue;
            return true;
        }
        for (i2 = 0; i2 < y2.length; ++i2) {
            if (values.add(y2[i2])) continue;
            return true;
        }
        return false;
    }

    private static void jitter(double[] data, RealDistribution dist) {
        int i2 = 0;
        while (i2 < data.length) {
            int n2 = i2++;
            data[n2] = data[n2] + dist.sample();
        }
    }

    private static int c(int i2, int j2, int m2, int n2, long cmn, boolean strict) {
        if (strict) {
            return FastMath.abs((long)i2 * (long)n2 - (long)j2 * (long)m2) <= cmn ? 1 : 0;
        }
        return FastMath.abs((long)i2 * (long)n2 - (long)j2 * (long)m2) < cmn ? 1 : 0;
    }

    private static double n(int i2, int j2, int m2, int n2, long cnm, boolean strict) {
        int k2;
        double[] lag = new double[n2];
        double last = 0.0;
        for (k2 = 0; k2 < n2; ++k2) {
            lag[k2] = KolmogorovSmirnovTest.c(0, k2 + 1, m2, n2, cnm, strict);
        }
        for (k2 = 1; k2 <= i2; ++k2) {
            last = KolmogorovSmirnovTest.c(k2, 0, m2, n2, cnm, strict);
            for (int l2 = 1; l2 <= j2; ++l2) {
                lag[l2 - 1] = (double)KolmogorovSmirnovTest.c(k2, l2, m2, n2, cnm, strict) * (last + lag[l2 - 1]);
                last = lag[l2 - 1];
            }
        }
        return last;
    }
}

