/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import org.apache.commons.math3.analysis.TrivariateFunction;
import org.apache.commons.math3.exception.OutOfRangeException;

class TricubicFunction
implements TrivariateFunction {
    private static final short N = 4;
    private final double[][][] a = new double[4][4][4];

    TricubicFunction(double[] aV) {
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int j2 = 0; j2 < 4; ++j2) {
                for (int k2 = 0; k2 < 4; ++k2) {
                    this.a[i2][j2][k2] = aV[i2 + 4 * (j2 + 4 * k2)];
                }
            }
        }
    }

    public double value(double x2, double y2, double z2) throws OutOfRangeException {
        if (x2 < 0.0 || x2 > 1.0) {
            throw new OutOfRangeException(x2, (Number)0, 1);
        }
        if (y2 < 0.0 || y2 > 1.0) {
            throw new OutOfRangeException(y2, (Number)0, 1);
        }
        if (z2 < 0.0 || z2 > 1.0) {
            throw new OutOfRangeException(z2, (Number)0, 1);
        }
        double x22 = x2 * x2;
        double x3 = x22 * x2;
        double[] pX = new double[]{1.0, x2, x22, x3};
        double y22 = y2 * y2;
        double y3 = y22 * y2;
        double[] pY = new double[]{1.0, y2, y22, y3};
        double z22 = z2 * z2;
        double z3 = z22 * z2;
        double[] pZ = new double[]{1.0, z2, z22, z3};
        double result = 0.0;
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int j2 = 0; j2 < 4; ++j2) {
                for (int k2 = 0; k2 < 4; ++k2) {
                    result += this.a[i2][j2][k2] * pX[i2] * pY[j2] * pZ[k2];
                }
            }
        }
        return result;
    }
}

