/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.integration.gauss;

import java.math.BigDecimal;
import java.math.MathContext;
import org.apache.commons.math3.analysis.integration.gauss.BaseRuleFactory;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegendreHighPrecisionRuleFactory
extends BaseRuleFactory<BigDecimal> {
    private final MathContext mContext;
    private final BigDecimal two;
    private final BigDecimal minusOne;
    private final BigDecimal oneHalf;

    public LegendreHighPrecisionRuleFactory() {
        this(MathContext.DECIMAL128);
    }

    public LegendreHighPrecisionRuleFactory(MathContext mContext) {
        this.mContext = mContext;
        this.two = new BigDecimal("2", mContext);
        this.minusOne = new BigDecimal("-1", mContext);
        this.oneHalf = new BigDecimal("0.5", mContext);
    }

    @Override
    protected Pair<BigDecimal[], BigDecimal[]> computeRule(int numberOfPoints) throws DimensionMismatchException {
        if (numberOfPoints == 1) {
            return new Pair<BigDecimal[], BigDecimal[]>(new BigDecimal[]{BigDecimal.ZERO}, new BigDecimal[]{this.two});
        }
        BigDecimal[] previousPoints = (BigDecimal[])this.getRuleInternal(numberOfPoints - 1).getFirst();
        BigDecimal[] points = new BigDecimal[numberOfPoints];
        BigDecimal[] weights = new BigDecimal[numberOfPoints];
        int iMax = numberOfPoints / 2;
        for (int i2 = 0; i2 < iMax; ++i2) {
            BigDecimal tmp2;
            BigDecimal tmp1;
            BigDecimal a2 = i2 == 0 ? this.minusOne : previousPoints[i2 - 1];
            BigDecimal b2 = iMax == 1 ? BigDecimal.ONE : previousPoints[i2];
            BigDecimal pma = BigDecimal.ONE;
            BigDecimal pa = a2;
            BigDecimal pmb = BigDecimal.ONE;
            BigDecimal pb2 = b2;
            for (int j2 = 1; j2 < numberOfPoints; ++j2) {
                BigDecimal b_two_j_p_1 = new BigDecimal(2 * j2 + 1, this.mContext);
                BigDecimal b_j = new BigDecimal(j2, this.mContext);
                BigDecimal b_j_p_1 = new BigDecimal(j2 + 1, this.mContext);
                tmp1 = a2.multiply(b_two_j_p_1, this.mContext);
                tmp1 = pa.multiply(tmp1, this.mContext);
                tmp2 = pma.multiply(b_j, this.mContext);
                BigDecimal ppa = tmp1.subtract(tmp2, this.mContext);
                ppa = ppa.divide(b_j_p_1, this.mContext);
                tmp1 = b2.multiply(b_two_j_p_1, this.mContext);
                tmp1 = pb2.multiply(tmp1, this.mContext);
                tmp2 = pmb.multiply(b_j, this.mContext);
                BigDecimal ppb = tmp1.subtract(tmp2, this.mContext);
                ppb = ppb.divide(b_j_p_1, this.mContext);
                pma = pa;
                pa = ppa;
                pmb = pb2;
                pb2 = ppb;
            }
            BigDecimal c2 = a2.add(b2, this.mContext).multiply(this.oneHalf, this.mContext);
            BigDecimal pmc = BigDecimal.ONE;
            BigDecimal pc2 = c2;
            boolean done = false;
            while (!done) {
                tmp1 = b2.subtract(a2, this.mContext);
                done = tmp1.compareTo(tmp2 = c2.ulp().multiply(BigDecimal.TEN, this.mContext)) <= 0;
                pmc = BigDecimal.ONE;
                pc2 = c2;
                for (int j3 = 1; j3 < numberOfPoints; ++j3) {
                    BigDecimal b_two_j_p_1 = new BigDecimal(2 * j3 + 1, this.mContext);
                    BigDecimal b_j = new BigDecimal(j3, this.mContext);
                    BigDecimal b_j_p_1 = new BigDecimal(j3 + 1, this.mContext);
                    tmp1 = c2.multiply(b_two_j_p_1, this.mContext);
                    tmp1 = pc2.multiply(tmp1, this.mContext);
                    tmp2 = pmc.multiply(b_j, this.mContext);
                    BigDecimal ppc = tmp1.subtract(tmp2, this.mContext);
                    ppc = ppc.divide(b_j_p_1, this.mContext);
                    pmc = pc2;
                    pc2 = ppc;
                }
                if (done) continue;
                if (pa.signum() * pc2.signum() <= 0) {
                    b2 = c2;
                    pmb = pmc;
                    pb2 = pc2;
                } else {
                    a2 = c2;
                    pma = pmc;
                    pa = pc2;
                }
                c2 = a2.add(b2, this.mContext).multiply(this.oneHalf, this.mContext);
            }
            BigDecimal nP = new BigDecimal(numberOfPoints, this.mContext);
            BigDecimal tmp12 = pmc.subtract(c2.multiply(pc2, this.mContext), this.mContext);
            tmp12 = tmp12.multiply(nP);
            tmp12 = tmp12.pow(2, this.mContext);
            BigDecimal tmp22 = c2.pow(2, this.mContext);
            tmp22 = BigDecimal.ONE.subtract(tmp22, this.mContext);
            tmp22 = tmp22.multiply(this.two, this.mContext);
            tmp22 = tmp22.divide(tmp12, this.mContext);
            points[i2] = c2;
            weights[i2] = tmp22;
            int idx = numberOfPoints - i2 - 1;
            points[idx] = c2.negate(this.mContext);
            weights[idx] = tmp22;
        }
        if (numberOfPoints % 2 != 0) {
            BigDecimal pmc = BigDecimal.ONE;
            for (int j4 = 1; j4 < numberOfPoints; j4 += 2) {
                BigDecimal b_j = new BigDecimal(j4, this.mContext);
                BigDecimal b_j_p_1 = new BigDecimal(j4 + 1, this.mContext);
                pmc = pmc.multiply(b_j, this.mContext);
                pmc = pmc.divide(b_j_p_1, this.mContext);
                pmc = pmc.negate(this.mContext);
            }
            BigDecimal nP = new BigDecimal(numberOfPoints, this.mContext);
            BigDecimal tmp1 = pmc.multiply(nP, this.mContext);
            tmp1 = tmp1.pow(2, this.mContext);
            BigDecimal tmp2 = this.two.divide(tmp1, this.mContext);
            points[iMax] = BigDecimal.ZERO;
            weights[iMax] = tmp2;
        }
        return new Pair<BigDecimal[], BigDecimal[]>(points, weights);
    }
}

