/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.turboproject;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import net.sf.mpxj.common.StreamHelper;
import net.sf.mpxj.turboproject.MapRow;
import net.sf.mpxj.turboproject.PEPUtility;

class Table
implements Iterable<MapRow> {
    private final Map<Integer, MapRow> m_rows = new TreeMap<Integer, MapRow>();

    Table() {
    }

    @Override
    public Iterator<MapRow> iterator() {
        return this.m_rows.values().iterator();
    }

    public void read(InputStream is) throws IOException {
        byte[] headerBlock = new byte[20];
        is.read(headerBlock);
        int headerLength = PEPUtility.getShort(headerBlock, 8);
        int recordCount = PEPUtility.getInt(headerBlock, 10);
        int recordLength = PEPUtility.getInt(headerBlock, 16);
        StreamHelper.skip(is, headerLength - headerBlock.length);
        byte[] record = new byte[recordLength];
        for (int recordIndex = 1; recordIndex <= recordCount; ++recordIndex) {
            is.read(record);
            this.readRow(recordIndex, record);
        }
    }

    public MapRow find(Integer uniqueID) {
        return this.m_rows.get(uniqueID);
    }

    protected void readRow(int uniqueID, byte[] data) {
    }

    protected void addRow(int uniqueID, Map<String, Object> map) {
        this.m_rows.put(uniqueID, new MapRow(map));
    }
}

