/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.synchro;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import net.sf.mpxj.common.ByteArrayHelper;
import net.sf.mpxj.synchro.SynchroTable;

final class SynchroLogger {
    private static String LOG_FILE;
    private static PrintWriter LOG;

    private SynchroLogger() {
    }

    public static void setLogFile(String logFile) {
        LOG_FILE = logFile;
    }

    public static void openLogFile() throws IOException {
        if (LOG_FILE != null) {
            System.out.println("SynchroLogger Configured");
            LOG = new PrintWriter(new FileWriter(LOG_FILE));
        }
    }

    public static void closeLogFile() {
        if (LOG_FILE != null) {
            LOG.flush();
            LOG.close();
        }
    }

    public static void log(String label, byte[] data) {
        if (LOG != null) {
            LOG.write(label);
            LOG.write(": ");
            LOG.println(ByteArrayHelper.hexdump(data, true));
            LOG.flush();
        }
    }

    public static void log(String label, String data) {
        if (LOG != null) {
            LOG.write(label);
            LOG.write(": ");
            LOG.println(data);
            LOG.flush();
        }
    }

    public static void log(String label, SynchroTable data) {
        if (LOG != null) {
            LOG.write(label);
            LOG.write(": ");
            LOG.println(data.toString());
            LOG.flush();
        }
    }

    public static void log(byte[] data) {
        if (LOG != null) {
            LOG.println(ByteArrayHelper.hexdump(data, true, 16, ""));
            LOG.flush();
        }
    }

    public static void log(String label, Class<?> klass, Map<String, Object> map) {
        if (LOG != null) {
            LOG.write(label);
            LOG.write(": ");
            LOG.println(klass.getSimpleName());
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                LOG.println(entry.getKey() + ": " + entry.getValue());
            }
            LOG.println();
            LOG.flush();
        }
    }
}

