/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.synchro;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.sf.mpxj.common.StreamHelper;
import net.sf.mpxj.synchro.BytesReadInputStream;
import net.sf.mpxj.synchro.DatatypeConverter;
import net.sf.mpxj.synchro.StreamReader;
import net.sf.mpxj.synchro.SynchroLogger;
import net.sf.mpxj.synchro.SynchroTable;

class SynchroData {
    private int m_majorVersion;
    private int m_minorVersion;
    private int m_offset;
    private Map<String, byte[]> m_tableData = new HashMap<String, byte[]>();
    private static final Set<String> REQUIRED_TABLES = new HashSet<String>(Arrays.asList("Tasks", "Calendars", "Companies"));

    SynchroData() {
    }

    public void process(InputStream is) throws Exception {
        this.readHeader(is);
        this.readVersion(is);
        this.readTableData(this.readTableHeaders(is), is);
    }

    public StreamReader getTableData(String name) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(this.m_tableData.get(name));
        if (this.m_majorVersion > 5) {
            byte[] header = new byte[24];
            stream.read(header);
            SynchroLogger.log("TABLE HEADER", header);
        }
        return new StreamReader(this.m_majorVersion, this.m_minorVersion, stream);
    }

    private List<SynchroTable> readTableHeaders(InputStream is) throws IOException {
        ArrayList<SynchroTable> tables = new ArrayList<SynchroTable>();
        byte[] header = new byte[48];
        while (true) {
            is.read(header);
            this.m_offset += 48;
            SynchroTable table = this.readTableHeader(header);
            if (table == null) break;
            tables.add(table);
        }
        Collections.sort(tables, new Comparator<SynchroTable>(){

            @Override
            public int compare(SynchroTable o1, SynchroTable o2) {
                return o1.getOffset() - o2.getOffset();
            }
        });
        SynchroTable previousTable = null;
        for (SynchroTable table : tables) {
            if (previousTable != null) {
                previousTable.setLength(table.getOffset() - previousTable.getOffset());
            }
            previousTable = table;
        }
        for (SynchroTable table : tables) {
            SynchroLogger.log("TABLE", table);
        }
        return tables;
    }

    private SynchroTable readTableHeader(byte[] header) {
        SynchroTable result = null;
        String tableName = DatatypeConverter.getSimpleString(header, 0);
        if (!tableName.isEmpty()) {
            int offset = DatatypeConverter.getInt(header, 40);
            result = new SynchroTable(tableName, offset);
        }
        return result;
    }

    private void readTableData(List<SynchroTable> tables, InputStream is) throws IOException {
        for (SynchroTable table : tables) {
            if (!REQUIRED_TABLES.contains(table.getName())) continue;
            this.readTable(is, table);
        }
    }

    private void readTable(InputStream is, SynchroTable table) throws IOException {
        int skip = table.getOffset() - this.m_offset;
        if (skip != 0) {
            StreamHelper.skip(is, skip);
            this.m_offset += skip;
        }
        String tableName = DatatypeConverter.getString(is);
        int tableNameLength = 2 + tableName.length();
        this.m_offset += tableNameLength;
        int dataLength = table.getLength() == -1 ? is.available() : table.getLength() - tableNameLength;
        SynchroLogger.log("READ", tableName);
        byte[] compressedTableData = new byte[dataLength];
        is.read(compressedTableData);
        this.m_offset += dataLength;
        Inflater inflater = new Inflater();
        inflater.setInput(compressedTableData);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(compressedTableData.length);
        byte[] buffer = new byte[1024];
        while (!inflater.finished()) {
            int count;
            try {
                count = inflater.inflate(buffer);
            }
            catch (DataFormatException ex) {
                throw new IOException(ex);
            }
            outputStream.write(buffer, 0, count);
        }
        outputStream.close();
        byte[] uncompressedTableData = outputStream.toByteArray();
        SynchroLogger.log(uncompressedTableData);
        this.m_tableData.put(table.getName(), uncompressedTableData);
    }

    private void readHeader(InputStream is) throws IOException {
        byte[] header = new byte[20];
        is.read(header);
        this.m_offset += 20;
        SynchroLogger.log("HEADER", header);
    }

    private void readVersion(InputStream is) throws IOException {
        BytesReadInputStream bytesReadStream = new BytesReadInputStream(is);
        String version = DatatypeConverter.getString(bytesReadStream);
        this.m_offset += bytesReadStream.getBytesRead();
        SynchroLogger.log("VERSION", version);
        String[] versionArray = version.split("\\.");
        this.m_majorVersion = Integer.parseInt(versionArray[0]);
        this.m_minorVersion = Integer.parseInt(versionArray[1]);
    }
}

