/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.synchro;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import net.sf.mpxj.Duration;
import net.sf.mpxj.common.ByteArray;
import net.sf.mpxj.synchro.BlockReader;
import net.sf.mpxj.synchro.DatatypeConverter;
import net.sf.mpxj.synchro.MapRow;
import net.sf.mpxj.synchro.TableReader;
import net.sf.mpxj.synchro.UnknownBlockReader;
import net.sf.mpxj.synchro.UnknownTableReader;

class StreamReader {
    private final int m_majorVersion;
    private final int m_minorVersion;
    private final InputStream m_stream;

    public StreamReader(int majorVersion, int minorVersion, InputStream stream) {
        this.m_majorVersion = majorVersion;
        this.m_minorVersion = minorVersion;
        this.m_stream = stream;
    }

    public Integer readByte() throws IOException {
        return this.m_stream.read();
    }

    public Boolean readBoolean() throws IOException {
        return DatatypeConverter.getBoolean(this.m_stream);
    }

    public List<MapRow> readTable(TableReader reader) throws IOException {
        reader.read();
        return reader.getRows();
    }

    public List<MapRow> readUnknownTable(int rowSize, int rowMagicNumber) throws IOException {
        UnknownTableReader reader = new UnknownTableReader(this, rowSize, rowMagicNumber);
        reader.read();
        return reader.getRows();
    }

    public List<MapRow> readTable(Class<? extends TableReader> readerClass) throws IOException {
        TableReader reader;
        try {
            reader = readerClass.getConstructor(StreamReader.class).newInstance(this);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return this.readTable(reader);
    }

    public List<MapRow> readTableConditional(Class<? extends TableReader> readerClass) throws IOException {
        List<MapRow> result = DatatypeConverter.getBoolean(this.m_stream) ? this.readTable(readerClass) : Collections.emptyList();
        return result;
    }

    public List<MapRow> readUnknownTableConditional(int rowSize, int rowMagicNumber) throws IOException {
        List<MapRow> result = DatatypeConverter.getBoolean(this.m_stream) ? this.readUnknownTable(rowSize, rowMagicNumber) : Collections.emptyList();
        return result;
    }

    public ByteArray readBytes(int size) throws IOException {
        byte[] data = new byte[size];
        this.m_stream.read(data);
        return new ByteArray(data);
    }

    public UUID readUUID() throws IOException {
        return DatatypeConverter.getUUID(this.m_stream);
    }

    public String readString() throws IOException {
        return DatatypeConverter.getString(this.m_stream);
    }

    public Date readDate() throws IOException {
        return DatatypeConverter.getDate(this.m_stream);
    }

    public Date readTime() throws IOException {
        return DatatypeConverter.getTime(this.m_stream);
    }

    public Duration readDuration() throws IOException {
        return DatatypeConverter.getDuration(this.m_stream);
    }

    public int readInt() throws IOException {
        return DatatypeConverter.getInt(this.m_stream);
    }

    public Integer readInteger() throws IOException {
        return DatatypeConverter.getInteger(this.m_stream);
    }

    public Double readDouble() throws IOException {
        return DatatypeConverter.getDouble(this.m_stream);
    }

    public List<MapRow> readUnknownBlocks(int size) throws IOException {
        return new UnknownBlockReader(this, size).read();
    }

    public List<MapRow> readBlocks(Class<? extends BlockReader> readerClass) throws IOException {
        BlockReader reader;
        try {
            reader = readerClass.getConstructor(StreamReader.class).newInstance(this);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return reader.read();
    }

    public int getMajorVersion() {
        return this.m_majorVersion;
    }

    public int getMinorVersion() {
        return this.m_minorVersion;
    }

    public int getCombinedVersion() {
        return this.m_majorVersion * 100 + this.m_minorVersion;
    }
}

