/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.sdef;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.reader.AbstractProjectReader;
import net.sf.mpxj.sdef.ActivityRecord;
import net.sf.mpxj.sdef.CalendarRecord;
import net.sf.mpxj.sdef.Context;
import net.sf.mpxj.sdef.HolidayRecord;
import net.sf.mpxj.sdef.PrecedenceRecord;
import net.sf.mpxj.sdef.ProgressRecord;
import net.sf.mpxj.sdef.ProjectRecord;
import net.sf.mpxj.sdef.SDEFRecord;
import net.sf.mpxj.sdef.UnitCostRecord;
import net.sf.mpxj.sdef.VolumeRecord;

public final class SDEFReader
extends AbstractProjectReader {
    private List<ProjectListener> m_projectListeners;
    private static final Map<String, Class<? extends SDEFRecord>> RECORD_MAP = new HashMap<String, Class<? extends SDEFRecord>>();

    @Override
    public void addProjectListener(ProjectListener listener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(listener);
    }

    @Override
    public ProjectFile read(InputStream inputStream) throws MPXJException {
        Context context = new Context();
        ProjectFile project = context.getProject();
        CustomFieldContainer fields = project.getCustomFields();
        fields.getCustomField(TaskField.TEXT1).setAlias("Activity ID");
        fields.getCustomField(TaskField.TEXT2).setAlias("Hammock Code");
        fields.getCustomField(TaskField.NUMBER1).setAlias("Workers Per Day");
        fields.getCustomField(TaskField.TEXT3).setAlias("Responsibility Code");
        fields.getCustomField(TaskField.TEXT4).setAlias("Work Area Code");
        fields.getCustomField(TaskField.TEXT5).setAlias("Mod of Claim No");
        fields.getCustomField(TaskField.TEXT6).setAlias("Bide Item");
        fields.getCustomField(TaskField.TEXT7).setAlias("Phase of Work");
        fields.getCustomField(TaskField.TEXT8).setAlias("Category of Work");
        fields.getCustomField(TaskField.TEXT9).setAlias("Feature of Work");
        fields.getCustomField(TaskField.COST1).setAlias("Stored Material");
        project.getProjectProperties().setFileApplication("SDEF");
        project.getProjectProperties().setFileType("SDEF");
        context.getEventManager().addProjectListeners(this.m_projectListeners);
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            while (this.processLine(context, reader.readLine())) {
            }
        }
        catch (IOException ex) {
            throw new MPXJException("Error reading file", ex);
        }
        return project;
    }

    private boolean processLine(Context context, String line) throws MPXJException {
        SDEFRecord record;
        if (line == null || line.startsWith("END")) {
            return false;
        }
        String recordID = line.substring(0, 4);
        Class<? extends SDEFRecord> klass = RECORD_MAP.get(recordID);
        if (klass == null) {
            throw new MPXJException("Unknown record type: " + recordID);
        }
        try {
            record = klass.newInstance();
        }
        catch (Exception e2) {
            throw new MPXJException("Error reading file", e2);
        }
        record.read(line);
        record.process(context);
        return true;
    }

    static {
        RECORD_MAP.put("VOLM", VolumeRecord.class);
        RECORD_MAP.put("PROJ", ProjectRecord.class);
        RECORD_MAP.put("CLDR", CalendarRecord.class);
        RECORD_MAP.put("HOLI", HolidayRecord.class);
        RECORD_MAP.put("ACTV", ActivityRecord.class);
        RECORD_MAP.put("PRED", PrecedenceRecord.class);
        RECORD_MAP.put("UNIT", UnitCostRecord.class);
        RECORD_MAP.put("PROG", ProgressRecord.class);
    }
}

