/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.sdef;

import java.util.UUID;
import net.sf.mpxj.Task;
import net.sf.mpxj.sdef.AbstractSDEFRecord;
import net.sf.mpxj.sdef.ConstraintTypeField;
import net.sf.mpxj.sdef.Context;
import net.sf.mpxj.sdef.DateField;
import net.sf.mpxj.sdef.DurationField;
import net.sf.mpxj.sdef.IntegerField;
import net.sf.mpxj.sdef.SDEFField;
import net.sf.mpxj.sdef.StringField;

class ActivityRecord
extends AbstractSDEFRecord {
    private static final SDEFField[] FIELDS = new SDEFField[]{new StringField("Activity ID", 10), new StringField("Activity Description", 30), new DurationField("Activity Duration", 3), new DateField("Constraint Date"), new ConstraintTypeField("Constraint Type"), new StringField("Calendar Code", 1), new StringField("Hammock Code", 1), new IntegerField("Workers Per Day", 3), new StringField("Responsibility Code", 4), new StringField("Work Area Code", 4), new StringField("Mod of Claim No", 6), new StringField("Bid Item", 6), new StringField("Phase of Work", 2), new StringField("Category of Work", 1), new StringField("Feature of Work", 10)};

    ActivityRecord() {
    }

    @Override
    protected SDEFField[] getFieldDefinitions() {
        return FIELDS;
    }

    @Override
    public void process(Context context) {
        String activityID = this.getString(0);
        Task task = context.addTask(activityID);
        task.setText(1, activityID);
        task.setName(this.getString(1));
        task.setDuration(this.getDuration(2));
        task.setConstraintDate(this.getDate(3));
        task.setConstraintType(this.getConstraintType(4));
        task.setCalendar(context.getCalendar(this.getString(5)));
        task.setText(2, this.getString(6));
        task.setNumber(1, this.getInteger(7));
        task.setText(3, this.getString(8));
        task.setText(4, this.getString(9));
        task.setText(5, this.getString(10));
        task.setText(6, this.getString(11));
        task.setText(7, this.getString(12));
        task.setText(8, this.getString(13));
        task.setText(9, this.getString(14));
        task.setGUID(UUID.nameUUIDFromBytes(activityID.getBytes()));
        task.setMilestone(task.getDuration() != null && task.getDuration().getDuration() == 0.0);
        context.getEventManager().fireTaskReadEvent(task);
    }
}

