/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.sample;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.primavera.PrimaveraDatabaseReader;
import net.sf.mpxj.writer.ProjectWriter;
import net.sf.mpxj.writer.ProjectWriterUtility;

public final class PrimaveraConvert {
    public static void main(String[] args) {
        try {
            if (args.length != 4) {
                System.out.println("Usage: PrimaveraConvert <JDBC Driver Class> <JDBC connection string> <project ID> <output file name>");
            } else {
                PrimaveraConvert convert = new PrimaveraConvert();
                convert.process(args[0], args[1], args[2], args[3]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    public void process(String driverClass, String connectionString, String projectID, String outputFile) throws Exception {
        System.out.println("Reading Primavera database started.");
        Class.forName(driverClass);
        Properties props = new Properties();
        if (driverClass.equals("org.sqlite.JDBC")) {
            props.setProperty("date_string_format", "yyyy-MM-dd HH:mm:ss");
        }
        Connection c2 = DriverManager.getConnection(connectionString, props);
        PrimaveraDatabaseReader reader = new PrimaveraDatabaseReader();
        reader.setConnection(c2);
        this.processProject(reader, Integer.parseInt(projectID), outputFile);
    }

    private void processProject(PrimaveraDatabaseReader reader, int projectID, String outputFile) throws Exception {
        long start = System.currentTimeMillis();
        reader.setProjectID(projectID);
        ProjectFile projectFile = reader.read();
        long elapsed = System.currentTimeMillis() - start;
        System.out.println("Reading database completed in " + elapsed + "ms.");
        System.out.println("Writing output file started.");
        start = System.currentTimeMillis();
        ProjectWriter writer = ProjectWriterUtility.getProjectWriter(outputFile);
        writer.write(projectFile, outputFile);
        elapsed = System.currentTimeMillis() - start;
        System.out.println("Writing output completed in " + elapsed + "ms.");
    }
}

