/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.sample;

import java.io.File;
import java.io.FileFilter;
import net.sf.mpxj.sample.MpxjConvert;

public final class MpxjBatchConvert {
    public static void main(String[] args) {
        try {
            if (args.length != 4) {
                System.out.println("Usage: MpxjBatchConvert <source directory> <source suffix> <target directory> <target suffix>");
            } else {
                File sourceDirectory = new File(args[0]);
                final String sourceSuffix = args[1];
                String targetDirectory = args[2];
                String targetSuffix = args[3];
                File[] fileList = sourceDirectory.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.getName().endsWith(sourceSuffix);
                    }
                });
                if (fileList != null) {
                    MpxjConvert convert = new MpxjConvert();
                    for (File file : fileList) {
                        String oldName = file.getName();
                        String newName = oldName.substring(0, oldName.length() - sourceSuffix.length()) + targetSuffix;
                        File newFile = new File(targetDirectory, newName);
                        convert.process(file.getCanonicalPath(), newFile.getCanonicalPath());
                    }
                }
            }
            System.exit(0);
        }
        catch (Exception ex) {
            System.out.println();
            System.out.print("Conversion Error: ");
            ex.printStackTrace(System.out);
            System.out.println();
            System.exit(1);
        }
    }
}

