/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.reader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.asta.AstaDatabaseFileReader;
import net.sf.mpxj.asta.AstaDatabaseReader;
import net.sf.mpxj.asta.AstaFileReader;
import net.sf.mpxj.common.CharsetHelper;
import net.sf.mpxj.common.FileHelper;
import net.sf.mpxj.common.InputStreamHelper;
import net.sf.mpxj.common.StreamHelper;
import net.sf.mpxj.conceptdraw.ConceptDrawProjectReader;
import net.sf.mpxj.fasttrack.FastTrackReader;
import net.sf.mpxj.ganttdesigner.GanttDesignerReader;
import net.sf.mpxj.ganttproject.GanttProjectReader;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.merlin.MerlinReader;
import net.sf.mpxj.mpd.MPDDatabaseReader;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mpx.MPXReader;
import net.sf.mpxj.mspdi.MSPDIReader;
import net.sf.mpxj.phoenix.PhoenixInputStream;
import net.sf.mpxj.phoenix.PhoenixReader;
import net.sf.mpxj.planner.PlannerReader;
import net.sf.mpxj.primavera.PrimaveraDatabaseReader;
import net.sf.mpxj.primavera.PrimaveraPMFileReader;
import net.sf.mpxj.primavera.PrimaveraXERFileReader;
import net.sf.mpxj.primavera.p3.P3DatabaseReader;
import net.sf.mpxj.primavera.p3.P3PRXFileReader;
import net.sf.mpxj.primavera.suretrak.SureTrakDatabaseReader;
import net.sf.mpxj.primavera.suretrak.SureTrakSTXFileReader;
import net.sf.mpxj.projectlibre.ProjectLibreReader;
import net.sf.mpxj.reader.ProjectReader;
import net.sf.mpxj.sage.SageReader;
import net.sf.mpxj.sdef.SDEFReader;
import net.sf.mpxj.synchro.SynchroReader;
import net.sf.mpxj.turboproject.TurboProjectReader;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.CloseIgnoringInputStream;

public final class UniversalProjectReader
implements ProjectReader {
    private int m_skipBytes;
    private Charset m_charset;
    private List<ProjectListener> m_projectListeners;
    private static final int BUFFER_SIZE = 512;
    private static final byte[] OLE_COMPOUND_DOC_FINGERPRINT = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};
    private static final byte[] PP_FINGERPRINT = new byte[]{0, 0, 48, 48, 48, 48, 48, 48};
    private static final byte[] MPX_FINGERPRINT = new byte[]{77, 80, 88};
    private static final byte[] MDB_FINGERPRINT = new byte[]{0, 1, 0, 0, 83, 116, 97, 110, 100, 97, 114, 100, 32, 74, 101, 116, 32, 68, 66};
    private static final byte[] SQLITE_FINGERPRINT = new byte[]{83, 81, 76, 105, 116, 101, 32, 102, 111, 114, 109, 97, 116};
    private static final byte[] XER_FINGERPRINT = new byte[]{69, 82, 77, 72, 68, 82};
    private static final byte[] ZIP_FINGERPRINT = new byte[]{80, 75};
    private static final byte[] PHOENIX_FINGERPRINT = new byte[]{80, 80, 88, 33, 33, 33, 33};
    private static final byte[] BINARY_PLIST = new byte[]{98, 112, 108, 105, 115, 116};
    private static final byte[] FASTTRACK_FINGERPRINT = new byte[]{28, 0, 0, 0};
    private static final byte[] PROJECTLIBRE_FINGERPRINT = new byte[]{-84, -19, 0, 5};
    private static final byte[] BTRIEVE_FINGERPRINT = new byte[]{70, 67, 0, 0};
    private static final byte[] STW_FINGERPRINT = new byte[]{83, 84, 87};
    private static final byte[] DOS_EXE_FINGERPRINT = new byte[]{77, 90};
    private static final byte[] WINDOWS_NE_EXE_FINGERPRINT = new byte[]{78, 69};
    private static final byte[] STX_FINGERPRINT = new byte[]{85, -117};
    private static final byte[] SYNCHRO_FINGERPRINT = new byte[]{-74, 23};
    private static final byte[] SDEF_FINGERPRINT = new byte[]{86, 79, 76, 77};
    private static final byte[] SCHEDULE_GRID_FINGERPRINT = new byte[]{42, 42, 42, 42, 32, 83, 99, 104, 101, 100, 117, 108, 101, 32, 71, 114, 105, 100};
    private static final byte[] UTF8_BOM_FINGERPRINT = new byte[]{-17, -69, -65};
    private static final byte[] UTF16_BOM_FINGERPRINT = new byte[]{-2, -1};
    private static final byte[] UTF16LE_BOM_FINGERPRINT = new byte[]{-1, -2};
    private static final Pattern PLANNER_FINGERPRINT = Pattern.compile(".*<project.*mrproject-version.*", 32);
    private static final Pattern PMXML_FINGERPRINT = Pattern.compile(".*(<BusinessObjects|APIBusinessObjects).*", 32);
    private static final Pattern MSPDI_FINGERPRINT_1 = Pattern.compile(".*xmlns=\"http://schemas\\.microsoft\\.com/project.*", 32);
    private static final Pattern MSPDI_FINGERPRINT_2 = Pattern.compile(".*<Project.*<SaveVersion>.*", 32);
    private static final Pattern PHOENIX_XML_FINGERPRINT = Pattern.compile(".*<project.*version=\"(\\d+|\\d+\\.\\d+)\".*update_mode=\"(true|false)\".*>.*", 32);
    private static final Pattern GANTTPROJECT_FINGERPRINT = Pattern.compile(".*<project.*webLink.*", 32);
    private static final Pattern TURBOPROJECT_FINGERPRINT = Pattern.compile(".*dWBSTAB.*", 32);
    private static final Pattern PRX_FINGERPRINT = Pattern.compile("!Self-Extracting Primavera Project", 32);
    private static final Pattern PRX3_FINGERPRINT = Pattern.compile("PRX3", 32);
    private static final Pattern CONCEPT_DRAW_FINGERPRINT = Pattern.compile(".*Application=\\\"CDProject\\\".*", 32);
    private static final Pattern GANTT_DESIGNER_FINGERPRINT = Pattern.compile(".*<Gantt Version=.*", 32);

    @Override
    public void addProjectListener(ProjectListener listener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(listener);
    }

    void setSkipBytes(int skipBytes) {
        this.m_skipBytes = skipBytes;
    }

    void setCharset(Charset charset) {
        this.m_charset = charset;
    }

    @Override
    public ProjectFile read(String fileName) throws MPXJException {
        return this.read(new File(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ProjectFile read(File file) throws MPXJException {
        ProjectFile projectFile;
        if (file.isDirectory()) {
            return this.handleDirectory(file);
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            ProjectFile projectFile2 = this.read(fis);
            fis.close();
            projectFile = projectFile2;
        }
        catch (Throwable throwable) {
            try {
                StreamHelper.closeQuietly(fis);
                throw throwable;
            }
            catch (Exception ex) {
                throw new MPXJException("Invalid file format", ex);
            }
        }
        StreamHelper.closeQuietly(fis);
        return projectFile;
    }

    @Override
    public ProjectFile read(InputStream inputStream) throws MPXJException {
        try {
            BufferedInputStream bis = new BufferedInputStream(inputStream);
            bis.skip(this.m_skipBytes);
            bis.mark(512);
            byte[] buffer = new byte[512];
            int bytesRead = bis.read(buffer);
            bis.reset();
            if (bytesRead != 512) {
                return null;
            }
            if (this.matchesFingerprint(buffer, UTF8_BOM_FINGERPRINT)) {
                return this.handleByteOrderMark(bis, UTF8_BOM_FINGERPRINT.length, CharsetHelper.UTF8);
            }
            if (this.matchesFingerprint(buffer, UTF16_BOM_FINGERPRINT)) {
                return this.handleByteOrderMark(bis, UTF16_BOM_FINGERPRINT.length, CharsetHelper.UTF16);
            }
            if (this.matchesFingerprint(buffer, UTF16LE_BOM_FINGERPRINT)) {
                return this.handleByteOrderMark(bis, UTF16LE_BOM_FINGERPRINT.length, CharsetHelper.UTF16LE);
            }
            if (this.matchesFingerprint(buffer, BINARY_PLIST)) {
                return this.handleBinaryPropertyList(bis);
            }
            if (this.matchesFingerprint(buffer, OLE_COMPOUND_DOC_FINGERPRINT)) {
                return this.handleOleCompoundDocument(bis);
            }
            if (this.matchesFingerprint(buffer, MSPDI_FINGERPRINT_1) || this.matchesFingerprint(buffer, MSPDI_FINGERPRINT_2)) {
                MSPDIReader reader = new MSPDIReader();
                reader.setCharset(this.m_charset);
                return reader.read(bis);
            }
            if (this.matchesFingerprint(buffer, PP_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new AstaFileReader(), bis);
            }
            if (this.matchesFingerprint(buffer, MPX_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new MPXReader(), bis);
            }
            if (this.matchesFingerprint(buffer, XER_FINGERPRINT)) {
                return this.handleXerFile(bis);
            }
            if (this.matchesFingerprint(buffer, PLANNER_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new PlannerReader(), bis);
            }
            if (this.matchesFingerprint(buffer, PMXML_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new PrimaveraPMFileReader(), bis);
            }
            if (this.matchesFingerprint(buffer, MDB_FINGERPRINT)) {
                return this.handleMDBFile(bis);
            }
            if (this.matchesFingerprint(buffer, SQLITE_FINGERPRINT)) {
                return this.handleSQLiteFile(bis);
            }
            if (this.matchesFingerprint(buffer, ZIP_FINGERPRINT)) {
                return this.handleZipFile(bis);
            }
            if (this.matchesFingerprint(buffer, PHOENIX_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new PhoenixReader(), new PhoenixInputStream(bis));
            }
            if (this.matchesFingerprint(buffer, PHOENIX_XML_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new PhoenixReader(), bis);
            }
            if (this.matchesFingerprint(buffer, FASTTRACK_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new FastTrackReader(), bis);
            }
            if (this.matchesFingerprint(buffer, PROJECTLIBRE_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new ProjectLibreReader(), bis);
            }
            if (this.matchesFingerprint(buffer, GANTTPROJECT_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new GanttProjectReader(), bis);
            }
            if (this.matchesFingerprint(buffer, TURBOPROJECT_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new TurboProjectReader(), bis);
            }
            if (this.matchesFingerprint(buffer, DOS_EXE_FINGERPRINT)) {
                return this.handleDosExeFile(bis);
            }
            if (this.matchesFingerprint(buffer, CONCEPT_DRAW_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new ConceptDrawProjectReader(), bis);
            }
            if (this.matchesFingerprint(buffer, SYNCHRO_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new SynchroReader(), bis);
            }
            if (this.matchesFingerprint(buffer, GANTT_DESIGNER_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new GanttDesignerReader(), bis);
            }
            if (this.matchesFingerprint(buffer, SDEF_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new SDEFReader(), bis);
            }
            if (this.matchesFingerprint(buffer, SCHEDULE_GRID_FINGERPRINT)) {
                return this.readProjectFile((ProjectReader)new SageReader(), bis);
            }
            return null;
        }
        catch (Exception ex) {
            throw new MPXJException("Invalid file format", ex);
        }
    }

    private boolean matchesFingerprint(byte[] buffer, byte[] fingerprint) {
        return Arrays.equals(fingerprint, Arrays.copyOf(buffer, fingerprint.length));
    }

    private boolean matchesFingerprint(byte[] buffer, Pattern fingerprint) {
        return fingerprint.matcher(this.m_charset == null ? new String(buffer) : new String(buffer, this.m_charset)).matches();
    }

    private ProjectFile readProjectFile(ProjectReader reader, InputStream stream) throws MPXJException {
        this.addListeners(reader);
        return reader.read(stream);
    }

    private ProjectFile readProjectFile(ProjectReader reader, File file) throws MPXJException {
        this.addListeners(reader);
        return reader.read(file);
    }

    private ProjectFile handleOleCompoundDocument(InputStream stream) throws Exception {
        POIFSFileSystem fs = new POIFSFileSystem(new CloseIgnoringInputStream(stream));
        String fileFormat = MPPReader.getFileFormat(fs);
        if (fileFormat != null && fileFormat.startsWith("MSProject")) {
            MPPReader reader = new MPPReader();
            this.addListeners(reader);
            return reader.read(fs);
        }
        return null;
    }

    private ProjectFile handleBinaryPropertyList(InputStream stream) throws Exception {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectFile handleMDBFile(InputStream stream) throws Exception {
        File file = InputStreamHelper.writeStreamToTempFile(stream, ".mdb");
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            String url = "jdbc:odbc:DRIVER=Microsoft Access Driver (*.mdb);DBQ=" + file.getCanonicalPath();
            Set<String> tableNames = this.populateTableNames(url);
            if (tableNames.contains("MSP_PROJECTS")) {
                ProjectFile projectFile = this.readProjectFile((ProjectReader)new MPDDatabaseReader(), file);
                return projectFile;
            }
            if (tableNames.contains("EXCEPTIONN")) {
                ProjectFile projectFile = this.readProjectFile((ProjectReader)new AstaDatabaseReader(), file);
                return projectFile;
            }
            ProjectFile projectFile = null;
            return projectFile;
        }
        finally {
            FileHelper.deleteQuietly(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectFile handleSQLiteFile(InputStream stream) throws Exception {
        File file = InputStreamHelper.writeStreamToTempFile(stream, ".sqlite");
        try {
            Class.forName("org.sqlite.JDBC");
            String url = "jdbc:sqlite:" + file.getCanonicalPath();
            Set<String> tableNames = this.populateTableNames(url);
            if (tableNames.contains("EXCEPTIONN")) {
                ProjectFile projectFile = this.readProjectFile((ProjectReader)new AstaDatabaseFileReader(), file);
                return projectFile;
            }
            if (tableNames.contains("PROJWBS")) {
                try (Connection connection = null;){
                    Properties props = new Properties();
                    props.setProperty("date_string_format", "yyyy-MM-dd HH:mm:ss");
                    connection = DriverManager.getConnection(url, props);
                    PrimaveraDatabaseReader reader = new PrimaveraDatabaseReader();
                    reader.setConnection(connection);
                    this.addListeners(reader);
                    ProjectFile projectFile = reader.read();
                    return projectFile;
                }
            }
            if (tableNames.contains("ZSCHEDULEITEM")) {
                ProjectFile projectFile = this.readProjectFile((ProjectReader)new MerlinReader(), file);
                return projectFile;
            }
            ProjectFile projectFile = null;
            return projectFile;
        }
        finally {
            FileHelper.deleteQuietly(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectFile handleZipFile(InputStream stream) throws Exception {
        File dir = null;
        try {
            dir = InputStreamHelper.writeZipStreamToTempDir(stream);
            ProjectFile result = this.handleDirectory(dir);
            if (result != null) {
                ProjectFile projectFile = result;
                return projectFile;
            }
        }
        finally {
            FileHelper.deleteQuietly(dir);
        }
        return null;
    }

    private ProjectFile handleDirectory(File directory) throws Exception {
        ProjectFile result = this.handleDatabaseInDirectory(directory);
        if (result == null) {
            result = this.handleFileInDirectory(directory);
        }
        return result;
    }

    private ProjectFile handleDatabaseInDirectory(File directory) throws Exception {
        byte[] buffer = new byte[512];
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) continue;
                FileInputStream fis = new FileInputStream(file);
                int bytesRead = fis.read(buffer);
                fis.close();
                if (bytesRead != 512) continue;
                if (this.matchesFingerprint(buffer, BTRIEVE_FINGERPRINT)) {
                    return this.handleP3BtrieveDatabase(directory);
                }
                if (!this.matchesFingerprint(buffer, STW_FINGERPRINT)) continue;
                return this.handleSureTrakDatabase(directory);
            }
        }
        return null;
    }

    private ProjectFile handleFileInDirectory(File directory) throws Exception {
        ArrayList<File> directories = new ArrayList<File>();
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    directories.add(file);
                    continue;
                }
                UniversalProjectReader reader = new UniversalProjectReader();
                ProjectFile result = reader.read(file);
                if (result == null) continue;
                return result;
            }
            for (File file : directories) {
                ProjectFile result = this.handleDirectory(file);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private ProjectFile handleP3BtrieveDatabase(File directory) throws Exception {
        return P3DatabaseReader.setProjectNameAndRead(directory);
    }

    private ProjectFile handleSureTrakDatabase(File directory) throws Exception {
        return SureTrakDatabaseReader.setProjectNameAndRead(directory);
    }

    private ProjectFile handleByteOrderMark(InputStream stream, int length, Charset charset) throws Exception {
        UniversalProjectReader reader = new UniversalProjectReader();
        reader.setSkipBytes(length);
        reader.setCharset(charset);
        return reader.read(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectFile handleDosExeFile(InputStream stream) throws Exception {
        FileInputStream is;
        File file;
        block4: {
            byte[] data;
            block5: {
                ProjectFile projectFile;
                file = InputStreamHelper.writeStreamToTempFile(stream, ".tmp");
                is = null;
                try {
                    is = new FileInputStream(file);
                    if (((InputStream)is).available() <= 1350) break block4;
                    StreamHelper.skip(is, 1024L);
                    data = new byte[2];
                    ((InputStream)is).read(data);
                    if (!this.matchesFingerprint(data, WINDOWS_NE_EXE_FINGERPRINT)) break block5;
                    StreamHelper.skip(is, 286L);
                    data = new byte[34];
                    ((InputStream)is).read(data);
                    if (!this.matchesFingerprint(data, PRX_FINGERPRINT)) break block5;
                    ((InputStream)is).close();
                    is = null;
                    projectFile = this.readProjectFile((ProjectReader)new P3PRXFileReader(), file);
                }
                catch (Throwable throwable) {
                    StreamHelper.closeQuietly(is);
                    FileHelper.deleteQuietly(file);
                    throw throwable;
                }
                StreamHelper.closeQuietly(is);
                FileHelper.deleteQuietly(file);
                return projectFile;
            }
            if (!this.matchesFingerprint(data, STX_FINGERPRINT)) break block4;
            StreamHelper.skip(is, 31742L);
            data = new byte[4];
            ((InputStream)is).read(data);
            if (!this.matchesFingerprint(data, PRX3_FINGERPRINT)) break block4;
            ((InputStream)is).close();
            is = null;
            ProjectFile projectFile = this.readProjectFile((ProjectReader)new SureTrakSTXFileReader(), file);
            StreamHelper.closeQuietly(is);
            FileHelper.deleteQuietly(file);
            return projectFile;
        }
        ProjectFile projectFile = null;
        StreamHelper.closeQuietly(is);
        FileHelper.deleteQuietly(file);
        return projectFile;
    }

    private ProjectFile handleXerFile(InputStream stream) throws Exception {
        PrimaveraXERFileReader reader = new PrimaveraXERFileReader();
        reader.setCharset(this.m_charset);
        List<ProjectFile> projects = reader.readAll(stream);
        ProjectFile project = null;
        for (ProjectFile file : projects) {
            if (!file.getProjectProperties().getExportFlag()) continue;
            project = file;
            break;
        }
        if (project == null && !projects.isEmpty()) {
            project = projects.get(0);
        }
        return project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> populateTableNames(String url) throws SQLException {
        HashSet<String> tableNames = new HashSet<String>();
        Connection connection = null;
        ResultSet rs = null;
        try {
            connection = DriverManager.getConnection(url);
            DatabaseMetaData dmd = connection.getMetaData();
            rs = dmd.getTables(null, null, null, null);
            while (rs.next()) {
                tableNames.add(rs.getString("TABLE_NAME").toUpperCase());
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        return tableNames;
    }

    private void addListeners(ProjectReader reader) {
        if (this.m_projectListeners != null) {
            for (ProjectListener listener : this.m_projectListeners) {
                reader.addProjectListener(listener);
            }
        }
    }
}

