/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.reader;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.asta.AstaFileReader;
import net.sf.mpxj.fasttrack.FastTrackReader;
import net.sf.mpxj.ganttproject.GanttProjectReader;
import net.sf.mpxj.mpd.MPDDatabaseReader;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mpx.MPXReader;
import net.sf.mpxj.mspdi.MSPDIReader;
import net.sf.mpxj.phoenix.PhoenixReader;
import net.sf.mpxj.planner.PlannerReader;
import net.sf.mpxj.primavera.PrimaveraPMFileReader;
import net.sf.mpxj.primavera.PrimaveraXERFileReader;
import net.sf.mpxj.projectlibre.ProjectLibreReader;
import net.sf.mpxj.reader.ProjectReader;

public final class ProjectReaderUtility {
    private static final Map<String, Class<? extends ProjectReader>> READER_MAP = new HashMap<String, Class<? extends ProjectReader>>();

    private ProjectReaderUtility() {
    }

    public static ProjectReader getProjectReader(String name) throws MPXJException {
        int index = name.lastIndexOf(46);
        if (index == -1) {
            throw new IllegalArgumentException("Filename has no extension: " + name);
        }
        String extension = name.substring(index + 1).toUpperCase();
        Class<? extends ProjectReader> fileClass = READER_MAP.get(extension);
        if (fileClass == null) {
            throw new IllegalArgumentException("Cannot read files of type: " + extension);
        }
        try {
            ProjectReader file = fileClass.newInstance();
            return file;
        }
        catch (Exception ex) {
            throw new MPXJException("Failed to load project reader", ex);
        }
    }

    public static Set<String> getSupportedFileExtensions() {
        return READER_MAP.keySet();
    }

    static {
        READER_MAP.put("MPP", MPPReader.class);
        READER_MAP.put("MPT", MPPReader.class);
        READER_MAP.put("MPX", MPXReader.class);
        READER_MAP.put("XML", MSPDIReader.class);
        READER_MAP.put("MPD", MPDDatabaseReader.class);
        READER_MAP.put("PLANNER", PlannerReader.class);
        READER_MAP.put("XER", PrimaveraXERFileReader.class);
        READER_MAP.put("PMXML", PrimaveraPMFileReader.class);
        READER_MAP.put("PP", AstaFileReader.class);
        READER_MAP.put("PPX", PhoenixReader.class);
        READER_MAP.put("FTS", FastTrackReader.class);
        READER_MAP.put("POD", ProjectLibreReader.class);
        READER_MAP.put("GAN", GanttProjectReader.class);
    }
}

