/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.projectlibre;

import java.io.IOException;
import java.io.InputStream;

public class SearchableInputStream
extends InputStream {
    private final InputStream m_stream;
    private final byte[] m_pattern;
    private boolean m_searching = true;
    private boolean m_searchFailed;

    public SearchableInputStream(InputStream stream, String pattern) {
        this.m_stream = stream;
        this.m_pattern = pattern.getBytes();
    }

    @Override
    public int read() throws IOException {
        int c2;
        if (this.m_searching) {
            int index = 0;
            c2 = -1;
            while (this.m_searching) {
                c2 = this.m_stream.read();
                if (c2 == -1) {
                    this.m_searchFailed = true;
                    throw new IOException("Pattern not found");
                }
                if (c2 == this.m_pattern[index]) {
                    if (++index != this.m_pattern.length) continue;
                    this.m_searching = false;
                    c2 = this.m_stream.read();
                    continue;
                }
                index = 0;
            }
        } else {
            c2 = this.m_stream.read();
        }
        return c2;
    }

    public boolean getSearchFailed() {
        return this.m_searchFailed;
    }
}

