/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.mpxj.primavera.common.Huffman;

public class Blast {
    private int m_bitbuf;
    private int m_bitcnt;
    private InputStream m_input;
    private OutputStream m_output;
    private int m_left;
    private int m_in;
    private int m_first;
    private int m_next;
    private byte[] m_out = new byte[4096];
    private static final int MAXBITS = 13;
    private static final int MAXWIN = 4096;
    private static final int[] LITLEN = new int[]{11, 124, 8, 7, 28, 7, 188, 13, 76, 4, 10, 8, 12, 10, 12, 10, 8, 23, 8, 9, 7, 6, 7, 8, 7, 6, 55, 8, 23, 24, 12, 11, 7, 9, 11, 12, 6, 7, 22, 5, 7, 24, 6, 11, 9, 6, 7, 22, 7, 11, 38, 7, 9, 8, 25, 11, 8, 11, 9, 12, 8, 12, 5, 38, 5, 38, 5, 11, 7, 5, 6, 21, 6, 10, 53, 8, 7, 24, 10, 27, 44, 253, 253, 253, 252, 252, 252, 13, 12, 45, 12, 45, 12, 61, 12, 45, 44, 173};
    private static final int[] LENLEN = new int[]{2, 35, 36, 53, 38, 23};
    private static final int[] DISTLEN = new int[]{2, 20, 53, 230, 247, 151, 248};
    private static final short[] BASE = new short[]{3, 2, 4, 5, 6, 7, 8, 9, 10, 12, 16, 24, 40, 72, 136, 264};
    private static final int[] EXTRA = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final Huffman LITCODE = new Huffman(14, 256);
    private static final Huffman LENCODE = new Huffman(14, 16);
    private static final Huffman DISTCODE = new Huffman(14, 64);

    public int blast(InputStream input, OutputStream output) throws IOException {
        this.m_input = input;
        this.m_output = output;
        int lit = this.bits(8);
        if (lit > 1) {
            return -1;
        }
        int dict = this.bits(8);
        if (dict < 4 || dict > 6) {
            return -2;
        }
        while (true) {
            int symbol;
            if (this.bits(1) != 0) {
                symbol = this.decode(LENCODE);
                int len = BASE[symbol] + this.bits(EXTRA[symbol]);
                if (len == 519) break;
                symbol = len == 2 ? 2 : dict;
                int dist = this.decode(DISTCODE) << symbol;
                dist += this.bits(symbol);
                if (this.m_first != 0 && ++dist > this.m_next) {
                    return -3;
                }
                do {
                    int to = this.m_next;
                    int from = to - dist;
                    int copy = 4096;
                    if (this.m_next < dist) {
                        from += copy;
                        copy = dist;
                    }
                    if ((copy -= this.m_next) > len) {
                        copy = len;
                    }
                    len -= copy;
                    this.m_next += copy;
                    do {
                        this.m_out[to++] = this.m_out[from++];
                    } while (--copy != 0);
                    if (this.m_next != 4096) continue;
                    this.m_output.write(this.m_out, 0, this.m_next);
                    this.m_next = 0;
                    this.m_first = 0;
                } while (len != 0);
                continue;
            }
            symbol = lit != 0 ? this.decode(LITCODE) : this.bits(8);
            this.m_out[this.m_next++] = (byte)symbol;
            if (this.m_next != 4096) continue;
            this.m_output.write(this.m_out, 0, this.m_next);
            this.m_next = 0;
            this.m_first = 0;
        }
        if (this.m_next != 0) {
            this.m_output.write(this.m_out, 0, this.m_next);
        }
        return 0;
    }

    private int bits(int need) throws IOException {
        int val = this.m_bitbuf;
        while (this.m_bitcnt < need) {
            if (this.m_left == 0) {
                this.m_in = this.m_input.read();
                int n2 = this.m_left = this.m_in == -1 ? 0 : 1;
                if (this.m_left == 0) {
                    throw new IOException("out of input");
                }
            }
            val |= this.m_in << this.m_bitcnt;
            --this.m_left;
            this.m_bitcnt += 8;
        }
        this.m_bitbuf = val >> need;
        this.m_bitcnt -= need;
        return val & (1 << need) - 1;
    }

    private int decode(Huffman h2) throws IOException {
        int bitbuf = this.m_bitbuf;
        int left = this.m_bitcnt;
        int index = 0;
        int first = 0;
        int code = 0;
        int len = 1;
        int nextIndex = 1;
        while (true) {
            if (left-- != 0) {
                short count;
                if ((code |= (bitbuf >>= 1) & 1 ^ 1) < first + (count = h2.m_count[nextIndex++])) {
                    this.m_bitbuf = bitbuf;
                    this.m_bitcnt = this.m_bitcnt - len & 7;
                    return h2.m_symbol[index + (code - first)];
                }
                index += count;
                first += count;
                first <<= 1;
                code <<= 1;
                ++len;
                continue;
            }
            left = 14 - len;
            if (left == 0) break;
            if (this.m_left == 0) {
                this.m_in = this.m_input.read();
                int n2 = this.m_left = this.m_in == -1 ? 0 : 1;
                if (this.m_left == 0) {
                    throw new IOException("out of input");
                }
            }
            bitbuf = this.m_in;
            --this.m_left;
            if (left <= 8) continue;
            left = 8;
        }
        return -9;
    }

    private static int construct(Huffman h2, int[] rep, int n2) {
        int left;
        int len;
        short[] offs = new short[14];
        short[] length = new short[256];
        int symbol = 0;
        int repIndex = 0;
        do {
            len = rep[repIndex++];
            left = (len >> 4) + 1;
            len &= 0xF;
            do {
                length[symbol++] = (short)len;
            } while (--left != 0);
        } while (--n2 != 0);
        n2 = symbol;
        for (len = 0; len <= 13; ++len) {
            h2.m_count[len] = 0;
        }
        for (symbol = 0; symbol < n2; ++symbol) {
            short s2 = length[symbol];
            h2.m_count[s2] = (short)(h2.m_count[s2] + 1);
        }
        if (h2.m_count[0] == n2) {
            return 0;
        }
        left = 1;
        for (len = 1; len <= 13; ++len) {
            left <<= 1;
            if ((left -= h2.m_count[len]) >= 0) continue;
            return left;
        }
        offs[1] = 0;
        for (len = 1; len < 13; ++len) {
            offs[len + 1] = (short)(offs[len] + h2.m_count[len]);
        }
        for (symbol = 0; symbol < n2; ++symbol) {
            if (length[symbol] == 0) continue;
            short s3 = length[symbol];
            short s4 = offs[s3];
            offs[s3] = (short)(s4 + 1);
            h2.m_symbol[s4] = (short)symbol;
        }
        return left;
    }

    static {
        Blast.construct(LITCODE, LITLEN, LITLEN.length);
        Blast.construct(LENCODE, LENLEN, LENLEN.length);
        Blast.construct(DISTCODE, DISTLEN, DISTLEN.length);
    }
}

