/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera.common;

import java.util.ArrayList;
import java.util.List;

public class AbstractWbsFormat {
    private final List<String> m_elements = new ArrayList<String>();
    protected final List<Integer> m_lengths = new ArrayList<Integer>();
    protected final List<String> m_separators = new ArrayList<String>();

    public void parseRawValue(String value) {
        int elementLength;
        int valueIndex = 0;
        this.m_elements.clear();
        for (int elementIndex = 0; valueIndex < value.length() && elementIndex < this.m_elements.size(); valueIndex += elementLength, ++elementIndex) {
            int endIndex;
            elementLength = this.m_lengths.get(elementIndex);
            if (elementIndex > 0) {
                this.m_elements.add(this.m_separators.get(elementIndex - 1));
            }
            if ((endIndex = valueIndex + elementLength) > value.length()) {
                endIndex = value.length();
            }
            String element = value.substring(valueIndex, endIndex);
            this.m_elements.add(element);
        }
    }

    public String getFormattedValue() {
        return this.joinElements(this.m_elements.size());
    }

    public Integer getLevel() {
        return (this.m_elements.size() + 1) / 2;
    }

    public String getFormattedParentValue() {
        String result = null;
        if (this.m_elements.size() > 2) {
            result = this.joinElements(this.m_elements.size() - 2);
        }
        return result;
    }

    private String joinElements(int length) {
        StringBuilder sb2 = new StringBuilder();
        for (int index = 0; index < length; ++index) {
            sb2.append(this.m_elements.get(index));
        }
        return sb2.toString();
    }
}

