/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;

class PrimaveraInputStreamReader
extends InputStreamReader {
    private static final int REPLACEMENT_CHAR = 65533;

    public PrimaveraInputStreamReader(InputStream is, String charset) {
        super(is, PrimaveraInputStreamReader.decoder(charset));
    }

    @Override
    public int read() throws IOException {
        int c2 = super.read();
        if (!this.validXmlChar(c2)) {
            c2 = 65533;
        }
        return c2;
    }

    @Override
    public int read(char[] cbuf, int offset, int length) throws IOException {
        int result = super.read(cbuf, offset, length);
        if (result > 0) {
            for (int index = 0; index < result; ++index) {
                if (this.validXmlChar(cbuf[index])) continue;
                cbuf[index] = 65533;
            }
        }
        return result;
    }

    private boolean validXmlChar(int c2) {
        return c2 == 9 || c2 == 10 || c2 == 13 || c2 >= 32 && c2 <= 55295 || c2 >= 57344 && c2 <= 65533 || c2 >= 65536 && c2 <= 0x10FFFF;
    }

    private static CharsetDecoder decoder(String charset) {
        CharsetDecoder decoder = Charset.forName(charset).newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPLACE);
        decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        return decoder;
    }
}

