/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;

public final class DatatypeConverter {
    private static final ThreadLocal<DateFormat> DATE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            df.setLenient(false);
            return df;
        }
    };
    private static final ThreadLocal<DateFormat> TIME_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
            df.setLenient(false);
            return df;
        }
    };

    public static final UUID parseUUID(String value) {
        UUID result = null;
        if (value != null && !value.isEmpty()) {
            if (value.charAt(0) == '{') {
                result = UUID.fromString(value.substring(1, value.length() - 1));
            } else {
                int i2;
                byte[] data = javax.xml.bind.DatatypeConverter.parseBase64Binary(value + "==");
                long msb = 0L;
                long lsb = 0L;
                for (i2 = 0; i2 < 8; ++i2) {
                    msb = msb << 8 | (long)(data[i2] & 0xFF);
                }
                for (i2 = 8; i2 < 16; ++i2) {
                    lsb = lsb << 8 | (long)(data[i2] & 0xFF);
                }
                result = new UUID(msb, lsb);
            }
        }
        return result;
    }

    public static String printUUID(UUID guid) {
        return guid == null ? null : "{" + guid.toString().toUpperCase() + "}";
    }

    public static final String printDateTime(Date value) {
        return value == null ? null : DATE_FORMAT.get().format(value);
    }

    public static final Date parseDateTime(String value) {
        Date result = null;
        if (value != null && value.length() != 0) {
            try {
                result = DATE_FORMAT.get().parse(value);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return result;
    }

    public static final String printTime(Date value) {
        return value == null ? null : TIME_FORMAT.get().format(value);
    }

    public static final Date parseTime(String value) {
        Date result = null;
        if (value != null && value.length() != 0) {
            try {
                result = TIME_FORMAT.get().parse(value);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return result;
    }
}

