/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.phoenix;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.InflaterInputStream;
import net.sf.mpxj.common.CharsetHelper;

public class PhoenixInputStream
extends InputStream {
    private final InputStream m_stream;
    private final Map<String, String> m_properties = new HashMap<String, String>();

    public PhoenixInputStream(InputStream stream) throws IOException {
        this.m_stream = this.prepareInputStream(stream);
    }

    @Override
    public int read() throws IOException {
        return this.m_stream.read();
    }

    public String getVersion() {
        return this.m_properties.get("VERSION");
    }

    public boolean isCompressed() {
        String result = this.m_properties.get("COMPRESSION");
        return result != null && result.equals("yes");
    }

    private InputStream prepareInputStream(InputStream stream) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(stream);
        this.readHeaderProperties(bis);
        FilterInputStream result = this.isCompressed() ? new InflaterInputStream(bis) : bis;
        return result;
    }

    private String readHeaderString(BufferedInputStream stream) throws IOException {
        int bufferSize = 100;
        stream.mark(bufferSize);
        byte[] buffer = new byte[bufferSize];
        stream.read(buffer);
        Charset charset = CharsetHelper.UTF8;
        String header = new String(buffer, charset);
        int prefixIndex = header.indexOf("PPX!!!!|");
        int suffixIndex = header.indexOf("|!!!!XPP");
        if (prefixIndex != 0 || suffixIndex == -1) {
            throw new IOException("File format not recognised");
        }
        int skip = suffixIndex + 9;
        stream.reset();
        stream.skip(skip);
        return header.substring(prefixIndex + 8, suffixIndex);
    }

    private void readHeaderProperties(BufferedInputStream stream) throws IOException {
        String header = this.readHeaderString(stream);
        for (String property : header.split("\\|")) {
            String[] expression = property.split("=");
            this.m_properties.put(expression[0], expression[1]);
        }
    }
}

