/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mspdi;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import net.sf.mpxj.Duration;

final class XsdDuration {
    private boolean m_hasTime;
    private int m_years;
    private int m_months;
    private int m_days;
    private int m_hours;
    private int m_minutes;
    private double m_seconds;
    private static final DecimalFormatSymbols SYMBOLS = new DecimalFormatSymbols();
    private static final DecimalFormat FORMAT;

    XsdDuration(String duration) {
        int length;
        if (duration != null && (length = duration.length()) > 0) {
            boolean negative;
            int index;
            if (length == 1 && duration.charAt(0) == '0') {
                return;
            }
            if (duration.charAt(0) != 'P' && (length < 2 || duration.charAt(0) != '-' && duration.charAt(1) != 'P')) {
                throw new IllegalArgumentException(duration);
            }
            if (duration.charAt(0) == '-') {
                index = 2;
                negative = true;
            } else {
                index = 1;
                negative = false;
            }
            while (index < length) {
                index = this.readComponent(duration, index, length);
            }
            if (negative) {
                this.m_years = -this.m_years;
                this.m_months = -this.m_months;
                this.m_days = -this.m_days;
                this.m_hours = -this.m_hours;
                this.m_minutes = -this.m_minutes;
                this.m_seconds = -this.m_seconds;
            }
        }
    }

    XsdDuration(Duration duration) {
        double amount;
        if (duration != null && (amount = duration.getDuration()) != 0.0) {
            switch (duration.getUnits()) {
                case MINUTES: 
                case ELAPSED_MINUTES: {
                    this.m_minutes = (int)amount;
                    this.m_seconds = amount * 60.0 - (double)(this.m_minutes * 60);
                    break;
                }
                case HOURS: 
                case ELAPSED_HOURS: {
                    this.m_hours = (int)amount;
                    amount = amount * 60.0 - (double)(this.m_hours * 60);
                    this.m_minutes = (int)amount;
                    this.m_seconds = amount * 60.0 - (double)(this.m_minutes * 60);
                    break;
                }
                case DAYS: 
                case ELAPSED_DAYS: {
                    this.m_days = (int)amount;
                    amount = amount * 24.0 - (double)(this.m_days * 24);
                    this.m_hours = (int)amount;
                    amount = amount * 60.0 - (double)(this.m_hours * 60);
                    this.m_minutes = (int)amount;
                    this.m_seconds = amount * 60.0 - (double)(this.m_minutes * 60);
                    break;
                }
                case WEEKS: 
                case ELAPSED_WEEKS: {
                    this.m_days = (int)(amount *= 7.0);
                    amount = amount * 24.0 - (double)(this.m_days * 24);
                    this.m_hours = (int)amount;
                    amount = amount * 60.0 - (double)(this.m_hours * 60);
                    this.m_minutes = (int)amount;
                    this.m_seconds = amount * 60.0 - (double)(this.m_minutes * 60);
                    break;
                }
                case MONTHS: 
                case ELAPSED_MONTHS: {
                    this.m_months = (int)amount;
                    amount = amount * 28.0 - (double)(this.m_months * 28);
                    this.m_days = (int)amount;
                    amount = amount * 24.0 - (double)(this.m_days * 24);
                    this.m_hours = (int)amount;
                    amount = amount * 60.0 - (double)(this.m_hours * 60);
                    this.m_minutes = (int)amount;
                    this.m_seconds = amount * 60.0 - (double)(this.m_minutes * 60);
                    break;
                }
                case YEARS: 
                case ELAPSED_YEARS: {
                    this.m_years = (int)amount;
                    amount = amount * 12.0 - (double)(this.m_years * 12);
                    this.m_months = (int)amount;
                    amount = amount * 28.0 - (double)(this.m_months * 28);
                    this.m_days = (int)amount;
                    amount = amount * 24.0 - (double)(this.m_days * 24);
                    this.m_hours = (int)amount;
                    amount = amount * 60.0 - (double)(this.m_hours * 60);
                    this.m_minutes = (int)amount;
                    this.m_seconds = amount * 60.0 - (double)(this.m_minutes * 60);
                    break;
                }
            }
        }
    }

    private int readComponent(String duration, int index, int length) {
        char c2 = '\u0000';
        StringBuilder number = new StringBuilder();
        while (index < length && (Character.isDigit(c2 = (char)duration.charAt(index)) || c2 == '.' || c2 == '-')) {
            number.append(c2);
            ++index;
        }
        switch (c2) {
            case 'Y': {
                this.m_years = Integer.parseInt(number.toString());
                break;
            }
            case 'M': {
                if (!this.m_hasTime) {
                    this.m_months = Integer.parseInt(number.toString());
                    break;
                }
                this.m_minutes = Integer.parseInt(number.toString());
                break;
            }
            case 'D': {
                this.m_days = Integer.parseInt(number.toString());
                break;
            }
            case 'T': {
                this.m_hasTime = true;
                break;
            }
            case 'H': {
                this.m_hours = Integer.parseInt(number.toString());
                break;
            }
            case 'S': {
                this.m_seconds = Double.parseDouble(number.toString());
                break;
            }
            default: {
                throw new IllegalArgumentException(duration);
            }
        }
        return ++index;
    }

    public int getDays() {
        return this.m_days;
    }

    public int getHours() {
        return this.m_hours;
    }

    public int getMinutes() {
        return this.m_minutes;
    }

    public int getMonths() {
        return this.m_months;
    }

    public double getSeconds() {
        return this.m_seconds;
    }

    public int getYears() {
        return this.m_years;
    }

    public String print(boolean microsoftProjectCompatible) {
        StringBuilder buffer = new StringBuilder("P");
        boolean negative = false;
        if (this.m_years != 0 || this.m_months != 0 || this.m_days != 0) {
            if (this.m_years < 0) {
                negative = true;
                buffer.append(-this.m_years);
            } else {
                buffer.append(this.m_years);
            }
            buffer.append("Y");
            if (this.m_months < 0) {
                negative = true;
                buffer.append(-this.m_months);
            } else {
                buffer.append(this.m_months);
            }
            buffer.append("M");
            if (this.m_days < 0) {
                negative = true;
                buffer.append(-this.m_days);
            } else {
                buffer.append(this.m_days);
            }
            buffer.append("D");
        }
        buffer.append("T");
        if (this.m_hours < 0) {
            negative = true;
            buffer.append(-this.m_hours);
        } else {
            buffer.append(this.m_hours);
        }
        buffer.append("H");
        if (this.m_minutes < 0) {
            negative = true;
            buffer.append(-this.m_minutes);
        } else {
            buffer.append(this.m_minutes);
        }
        buffer.append("M");
        if (this.m_seconds < 0.0) {
            negative = true;
            buffer.append(FORMAT.format(-this.m_seconds));
        } else {
            buffer.append(FORMAT.format(this.m_seconds));
        }
        buffer.append("S");
        if (negative) {
            if (microsoftProjectCompatible) {
                for (int index = 0; index < buffer.length(); ++index) {
                    char c2 = buffer.charAt(index);
                    if (!Character.isDigit(c2) || c2 == '0') continue;
                    buffer.insert(index, '-');
                    break;
                }
            } else {
                buffer.insert(0, '-');
            }
        }
        return buffer.toString();
    }

    public String toString() {
        return this.print(true);
    }

    static {
        SYMBOLS.setDecimalSeparator('.');
        FORMAT = new DecimalFormat("#", SYMBOLS);
    }
}

