/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpx;

import java.util.Locale;
import net.sf.mpxj.CodePage;
import net.sf.mpxj.CurrencySymbolPosition;
import net.sf.mpxj.DateOrder;
import net.sf.mpxj.ProjectDateFormat;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.ProjectTimeFormat;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.mpx.LocaleData;

final class LocaleUtility {
    private static final Locale[] SUPPORTED_LOCALES = new Locale[]{new Locale("EN"), new Locale("DE"), new Locale("FR"), new Locale("IT"), new Locale("PT"), new Locale("SV"), new Locale("ZH"), new Locale("ES"), new Locale("RU")};

    private LocaleUtility() {
    }

    public static void setLocale(ProjectProperties properties, Locale locale) {
        properties.setMpxDelimiter(LocaleData.getChar(locale, "FILE_DELIMITER"));
        properties.setMpxProgramName(LocaleData.getString(locale, "PROGRAM_NAME"));
        properties.setMpxCodePage((CodePage)((Object)LocaleData.getObject(locale, "CODE_PAGE")));
        properties.setCurrencySymbol(LocaleData.getString(locale, "CURRENCY_SYMBOL"));
        properties.setSymbolPosition((CurrencySymbolPosition)LocaleData.getObject(locale, "CURRENCY_SYMBOL_POSITION"));
        properties.setCurrencyDigits(LocaleData.getInteger(locale, "CURRENCY_DIGITS"));
        properties.setThousandsSeparator(LocaleData.getChar(locale, "CURRENCY_THOUSANDS_SEPARATOR"));
        properties.setDecimalSeparator(LocaleData.getChar(locale, "CURRENCY_DECIMAL_SEPARATOR"));
        properties.setDateOrder((DateOrder)LocaleData.getObject(locale, "DATE_ORDER"));
        properties.setTimeFormat((ProjectTimeFormat)LocaleData.getObject(locale, "TIME_FORMAT"));
        properties.setDefaultStartTime(DateHelper.getTimeFromMinutesPastMidnight(LocaleData.getInteger(locale, "DEFAULT_START_TIME")));
        properties.setDateSeparator(LocaleData.getChar(locale, "DATE_SEPARATOR"));
        properties.setTimeSeparator(LocaleData.getChar(locale, "TIME_SEPARATOR"));
        properties.setAMText(LocaleData.getString(locale, "AM_TEXT"));
        properties.setPMText(LocaleData.getString(locale, "PM_TEXT"));
        properties.setDateFormat((ProjectDateFormat)LocaleData.getObject(locale, "DATE_FORMAT"));
        properties.setBarTextDateFormat((ProjectDateFormat)LocaleData.getObject(locale, "DATE_FORMAT"));
    }

    public static Locale[] getSupportedLocales() {
        return SUPPORTED_LOCALES;
    }
}

