/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import net.sf.mpxj.Day;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.RecurrenceType;
import net.sf.mpxj.RecurringTask;
import net.sf.mpxj.Task;
import net.sf.mpxj.mpp.MPPUtility;

final class RecurringTaskReader {
    private ProjectProperties m_properties;

    public RecurringTaskReader(ProjectProperties properties) {
        this.m_properties = properties;
    }

    public void processRecurringTask(Task task, byte[] data) {
        RecurringTask rt = task.addRecurringTask();
        rt.setStartDate(MPPUtility.getDate(data, 6));
        rt.setFinishDate(MPPUtility.getDate(data, 10));
        rt.setDuration(MPPUtility.getAdjustedDuration(this.m_properties, MPPUtility.getInt(data, 12), MPPUtility.getDurationTimeUnits(MPPUtility.getShort(data, 16))));
        rt.setOccurrences(MPPUtility.getShort(data, 18));
        rt.setRecurrenceType(RecurrenceType.getInstance(MPPUtility.getShort(data, 20)));
        rt.setUseEndDate(MPPUtility.getShort(data, 24) == 1);
        rt.setWorkingDaysOnly(MPPUtility.getShort(data, 26) == 1);
        rt.setWeeklyDay(Day.SUNDAY, MPPUtility.getShort(data, 28) == 1);
        rt.setWeeklyDay(Day.MONDAY, MPPUtility.getShort(data, 30) == 1);
        rt.setWeeklyDay(Day.TUESDAY, MPPUtility.getShort(data, 32) == 1);
        rt.setWeeklyDay(Day.WEDNESDAY, MPPUtility.getShort(data, 34) == 1);
        rt.setWeeklyDay(Day.THURSDAY, MPPUtility.getShort(data, 36) == 1);
        rt.setWeeklyDay(Day.FRIDAY, MPPUtility.getShort(data, 38) == 1);
        rt.setWeeklyDay(Day.SATURDAY, MPPUtility.getShort(data, 40) == 1);
        int frequencyOffset = 0;
        int dayOfWeekOffset = 0;
        int dayNumberOffset = 0;
        int monthNumberOffset = 0;
        int dateOffset = 0;
        switch (rt.getRecurrenceType()) {
            case DAILY: {
                frequencyOffset = 46;
                break;
            }
            case WEEKLY: {
                frequencyOffset = 48;
                break;
            }
            case MONTHLY: {
                rt.setRelative(MPPUtility.getShort(data, 42) == 1);
                if (rt.getRelative()) {
                    frequencyOffset = 58;
                    dayNumberOffset = 50;
                    dayOfWeekOffset = 52;
                    break;
                }
                frequencyOffset = 54;
                dayNumberOffset = 56;
                break;
            }
            case YEARLY: {
                rt.setRelative(MPPUtility.getShort(data, 44) != 1);
                if (rt.getRelative()) {
                    dayNumberOffset = 60;
                    dayOfWeekOffset = 62;
                    monthNumberOffset = 64;
                    break;
                }
                dateOffset = 70;
            }
        }
        if (frequencyOffset != 0) {
            rt.setFrequency(MPPUtility.getShort(data, frequencyOffset));
        }
        if (dayOfWeekOffset != 0) {
            rt.setDayOfWeek(Day.getInstance(MPPUtility.getShort(data, dayOfWeekOffset) + 1));
        }
        if (dayNumberOffset != 0) {
            rt.setDayNumber(MPPUtility.getShort(data, dayNumberOffset));
        }
        if (monthNumberOffset != 0) {
            rt.setMonthNumber(MPPUtility.getShort(data, monthNumberOffset));
        }
        if (dateOffset != 0) {
            rt.setYearlyAbsoluteFromDate(MPPUtility.getDate(data, dateOffset));
        }
    }
}

