/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Relation;
import net.sf.mpxj.Task;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.mpp.CompObj;
import net.sf.mpxj.mpp.MPP12Reader;
import net.sf.mpxj.mpp.MPP14Reader;
import net.sf.mpxj.mpp.MPP8Reader;
import net.sf.mpxj.mpp.MPP9Reader;
import net.sf.mpxj.mpp.MPPVariantReader;
import net.sf.mpxj.reader.AbstractProjectReader;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public final class MPPReader
extends AbstractProjectReader {
    private boolean m_preserveNoteFormatting;
    private boolean m_useRawTimephasedData;
    private boolean m_readPresentationData = true;
    private boolean m_readPropertiesOnly;
    private boolean m_respectPasswordProtection = true;
    private String m_readPassword;
    private List<ProjectListener> m_projectListeners;
    private static final Map<String, Class<? extends MPPVariantReader>> FILE_CLASS_MAP = new HashMap<String, Class<? extends MPPVariantReader>>();

    @Override
    public void addProjectListener(ProjectListener listener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(listener);
    }

    @Override
    public ProjectFile read(InputStream is) throws MPXJException {
        try {
            POIFSFileSystem fs = new POIFSFileSystem(is);
            return this.read(fs);
        }
        catch (IOException ex) {
            throw new MPXJException("Error reading file", ex);
        }
    }

    public static String getFileFormat(POIFSFileSystem fs) throws IOException {
        String fileFormat = "";
        DirectoryNode root = fs.getRoot();
        if (root.getEntryNames().contains("\u0001CompObj")) {
            CompObj compObj = new CompObj(new DocumentInputStream((DocumentEntry)root.getEntry("\u0001CompObj")));
            fileFormat = compObj.getFileFormat();
        }
        return fileFormat;
    }

    public ProjectFile read(POIFSFileSystem fs) throws MPXJException {
        try {
            ProjectFile projectFile = new ProjectFile();
            ProjectConfig config = projectFile.getProjectConfig();
            config.setAutoTaskID(false);
            config.setAutoTaskUniqueID(false);
            config.setAutoResourceID(false);
            config.setAutoResourceUniqueID(false);
            config.setAutoOutlineLevel(false);
            config.setAutoOutlineNumber(false);
            config.setAutoWBS(false);
            config.setAutoCalendarUniqueID(false);
            config.setAutoAssignmentUniqueID(false);
            projectFile.getEventManager().addProjectListeners(this.m_projectListeners);
            DirectoryNode root = fs.getRoot();
            CompObj compObj = new CompObj(new DocumentInputStream((DocumentEntry)root.getEntry("\u0001CompObj")));
            ProjectProperties projectProperties = projectFile.getProjectProperties();
            projectProperties.setFullApplicationName(compObj.getApplicationName());
            projectProperties.setApplicationVersion(compObj.getApplicationVersion());
            String format = compObj.getFileFormat();
            Class<? extends MPPVariantReader> readerClass = FILE_CLASS_MAP.get(format);
            if (readerClass == null) {
                throw new MPXJException("Invalid file format: " + format);
            }
            MPPVariantReader reader = readerClass.newInstance();
            reader.process(this, projectFile, root);
            config.setAutoOutlineNumber(true);
            projectFile.updateStructure();
            config.setAutoOutlineNumber(false);
            for (Task task : projectFile.getTasks()) {
                task.setSummary(task.hasChildTasks());
                List<DateRange> splits = task.getSplits();
                if (splits != null && splits.isEmpty()) {
                    task.setSplits(null);
                }
                this.validationRelations(task);
            }
            config.updateUniqueCounters();
            String projectFilePath = projectFile.getProjectProperties().getProjectFilePath();
            if (projectFilePath != null && projectFilePath.startsWith("<>\\")) {
                projectProperties.setFileApplication("Microsoft Project Server");
            } else {
                projectProperties.setFileApplication("Microsoft");
            }
            projectProperties.setFileType("MPP");
            return projectFile;
        }
        catch (IOException ex) {
            throw new MPXJException("Error reading file", ex);
        }
        catch (IllegalAccessException ex) {
            throw new MPXJException("Error reading file", ex);
        }
        catch (InstantiationException ex) {
            throw new MPXJException("Error reading file", ex);
        }
    }

    private void validationRelations(Task task) {
        List<Relation> predecessors = task.getPredecessors();
        if (!predecessors.isEmpty()) {
            ArrayList<Relation> invalid = new ArrayList<Relation>();
            for (Relation relation : predecessors) {
                Task sourceTask = relation.getSourceTask();
                Task targetTask = relation.getTargetTask();
                String sourceOutlineNumber = sourceTask.getOutlineNumber();
                String targetOutlineNumber = targetTask.getOutlineNumber();
                if (sourceOutlineNumber == null || targetOutlineNumber == null || !sourceOutlineNumber.startsWith(targetOutlineNumber + '.')) continue;
                invalid.add(relation);
            }
            for (Relation relation : invalid) {
                relation.getSourceTask().removePredecessor(relation.getTargetTask(), relation.getType(), relation.getLag());
            }
        }
    }

    public boolean getPreserveNoteFormatting() {
        return this.m_preserveNoteFormatting;
    }

    public void setPreserveNoteFormatting(boolean preserveNoteFormatting) {
        this.m_preserveNoteFormatting = preserveNoteFormatting;
    }

    public boolean getUseRawTimephasedData() {
        return this.m_useRawTimephasedData;
    }

    public void setUseRawTimephasedData(boolean useRawTimephasedData) {
        this.m_useRawTimephasedData = useRawTimephasedData;
    }

    public boolean getReadPresentationData() {
        return this.m_readPresentationData;
    }

    public void setReadPresentationData(boolean readPresentationData) {
        this.m_readPresentationData = readPresentationData;
    }

    public boolean getReadPropertiesOnly() {
        return this.m_readPropertiesOnly;
    }

    public void setReadPropertiesOnly(boolean readPropertiesOnly) {
        this.m_readPropertiesOnly = readPropertiesOnly;
    }

    public void setReadPassword(String password) {
        this.m_readPassword = password;
    }

    public String getReadPassword() {
        return this.m_readPassword;
    }

    public void setRespectPasswordProtection(boolean respectPasswordProtection) {
        this.m_respectPasswordProtection = respectPasswordProtection;
    }

    boolean getRespectPasswordProtection() {
        return this.m_respectPasswordProtection;
    }

    static {
        FILE_CLASS_MAP.put("MSProject.MPP9", MPP9Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPT9", MPP9Reader.class);
        FILE_CLASS_MAP.put("MSProject.GLOBAL9", MPP9Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPP8", MPP8Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPT8", MPP8Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPP12", MPP12Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPT12", MPP12Reader.class);
        FILE_CLASS_MAP.put("MSProject.GLOBAL12", MPP12Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPP14", MPP14Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPT14", MPP14Reader.class);
        FILE_CLASS_MAP.put("MSProject.GLOBAL14", MPP14Reader.class);
    }
}

