/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import net.sf.mpxj.mpp.MPPUtility;

class MPPComponent {
    protected MPPComponent() {
    }

    protected int readByte(InputStream is) throws IOException {
        byte[] data = new byte[1];
        if (is.read(data) != data.length) {
            throw new EOFException();
        }
        return MPPUtility.getByte(data, 0);
    }

    protected int readShort(InputStream is) throws IOException {
        byte[] data = new byte[2];
        if (is.read(data) != data.length) {
            throw new EOFException();
        }
        return MPPUtility.getShort(data, 0);
    }

    protected int readInt(InputStream is) throws IOException {
        byte[] data = new byte[4];
        if (is.read(data) != data.length) {
            throw new EOFException();
        }
        return MPPUtility.getInt(data, 0);
    }

    protected byte[] readByteArray(InputStream is, int size) throws IOException {
        byte[] buffer = new byte[size];
        if (is.read(buffer) != buffer.length) {
            throw new EOFException();
        }
        return buffer;
    }
}

