/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.ganttproject;

import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import net.sf.mpxj.ChildTaskContainer;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.CustomField;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectCalendarWeek;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.Pair;
import net.sf.mpxj.common.ResourceFieldLists;
import net.sf.mpxj.common.TaskFieldLists;
import net.sf.mpxj.ganttproject.CustomProperty;
import net.sf.mpxj.ganttproject.schema.Allocation;
import net.sf.mpxj.ganttproject.schema.Allocations;
import net.sf.mpxj.ganttproject.schema.Calendars;
import net.sf.mpxj.ganttproject.schema.CustomPropertyDefinition;
import net.sf.mpxj.ganttproject.schema.CustomResourceProperty;
import net.sf.mpxj.ganttproject.schema.CustomTaskProperty;
import net.sf.mpxj.ganttproject.schema.Date;
import net.sf.mpxj.ganttproject.schema.DayTypes;
import net.sf.mpxj.ganttproject.schema.DefaultWeek;
import net.sf.mpxj.ganttproject.schema.Depend;
import net.sf.mpxj.ganttproject.schema.Project;
import net.sf.mpxj.ganttproject.schema.Rate;
import net.sf.mpxj.ganttproject.schema.Resource;
import net.sf.mpxj.ganttproject.schema.Resources;
import net.sf.mpxj.ganttproject.schema.Role;
import net.sf.mpxj.ganttproject.schema.Roles;
import net.sf.mpxj.ganttproject.schema.Taskproperty;
import net.sf.mpxj.ganttproject.schema.Tasks;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.reader.AbstractProjectReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class GanttProjectReader
extends AbstractProjectReader {
    private ProjectFile m_projectFile;
    private ProjectCalendar m_mpxjCalendar;
    private EventManager m_eventManager;
    private List<ProjectListener> m_projectListeners;
    private DateFormat m_localeDateFormat;
    private DateFormat m_dateFormat;
    private Map<String, Pair<FieldType, String>> m_resourcePropertyDefinitions;
    private Map<String, Pair<FieldType, String>> m_taskPropertyDefinitions;
    private Map<String, String> m_roleDefinitions;
    private static final Map<String, CustomProperty> RESOURCE_PROPERTY_TYPES = new HashMap<String, CustomProperty>();
    private static final Map<String, CustomProperty> TASK_PROPERTY_TYPES;
    private static final int[] PRIORITY;
    static final RelationType[] RELATION;
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;

    @Override
    public void addProjectListener(ProjectListener listener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(listener);
    }

    @Override
    public ProjectFile read(InputStream stream) throws MPXJException {
        try {
            this.m_projectFile = new ProjectFile();
            this.m_eventManager = this.m_projectFile.getEventManager();
            this.m_resourcePropertyDefinitions = new HashMap<String, Pair<FieldType, String>>();
            this.m_taskPropertyDefinitions = new HashMap<String, Pair<FieldType, String>>();
            this.m_roleDefinitions = new HashMap<String, String>();
            this.m_dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SS'Z'");
            ProjectConfig config = this.m_projectFile.getProjectConfig();
            config.setAutoResourceUniqueID(false);
            config.setAutoTaskUniqueID(false);
            config.setAutoOutlineLevel(true);
            config.setAutoOutlineNumber(true);
            config.setAutoWBS(true);
            this.m_projectFile.getProjectProperties().setFileApplication("GanttProject");
            this.m_projectFile.getProjectProperties().setFileType("GAN");
            this.m_eventManager.addProjectListeners(this.m_projectListeners);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            SAXSource doc = new SAXSource(xmlReader, new InputSource(stream));
            if (CONTEXT == null) {
                throw CONTEXT_EXCEPTION;
            }
            Unmarshaller unmarshaller = CONTEXT.createUnmarshaller();
            Project ganttProject = (Project)unmarshaller.unmarshal(doc);
            this.readProjectProperties(ganttProject);
            this.readCalendars(ganttProject);
            this.readResources(ganttProject);
            this.readTasks(ganttProject);
            this.readRelationships(ganttProject);
            this.readResourceAssignments(ganttProject);
            config.updateUniqueCounters();
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        catch (ParserConfigurationException ex) {
            throw new MPXJException("Failed to parse file", ex);
        }
        catch (JAXBException ex) {
            throw new MPXJException("Failed to parse file", ex);
        }
        catch (SAXException ex) {
            throw new MPXJException("Failed to parse file", ex);
        }
        finally {
            this.m_projectFile = null;
            this.m_mpxjCalendar = null;
            this.m_eventManager = null;
            this.m_projectListeners = null;
            this.m_localeDateFormat = null;
            this.m_resourcePropertyDefinitions = null;
            this.m_taskPropertyDefinitions = null;
            this.m_roleDefinitions = null;
        }
    }

    private void readProjectProperties(Project ganttProject) {
        ProjectProperties mpxjProperties = this.m_projectFile.getProjectProperties();
        mpxjProperties.setName(ganttProject.getName());
        mpxjProperties.setCompany(ganttProject.getCompany());
        mpxjProperties.setDefaultDurationUnits(TimeUnit.DAYS);
        String locale = ganttProject.getLocale();
        if (locale == null) {
            locale = "en_US";
        }
        this.m_localeDateFormat = DateFormat.getDateInstance(3, new Locale(locale));
    }

    private void readCalendars(Project ganttProject) {
        this.m_mpxjCalendar = this.m_projectFile.addCalendar();
        this.m_mpxjCalendar.setName("Standard");
        Calendars gpCalendar = ganttProject.getCalendars();
        this.setWorkingDays(this.m_mpxjCalendar, gpCalendar);
        this.setExceptions(this.m_mpxjCalendar, gpCalendar);
        this.m_eventManager.fireCalendarReadEvent(this.m_mpxjCalendar);
    }

    private void setWorkingDays(ProjectCalendar mpxjCalendar, Calendars gpCalendar) {
        DayTypes dayTypes = gpCalendar.getDayTypes();
        DefaultWeek defaultWeek = dayTypes.getDefaultWeek();
        if (defaultWeek == null) {
            mpxjCalendar.setWorkingDay(Day.SUNDAY, false);
            mpxjCalendar.setWorkingDay(Day.MONDAY, true);
            mpxjCalendar.setWorkingDay(Day.TUESDAY, true);
            mpxjCalendar.setWorkingDay(Day.WEDNESDAY, true);
            mpxjCalendar.setWorkingDay(Day.THURSDAY, true);
            mpxjCalendar.setWorkingDay(Day.FRIDAY, true);
            mpxjCalendar.setWorkingDay(Day.SATURDAY, false);
        } else {
            mpxjCalendar.setWorkingDay(Day.MONDAY, this.isWorkingDay(defaultWeek.getMon()));
            mpxjCalendar.setWorkingDay(Day.TUESDAY, this.isWorkingDay(defaultWeek.getTue()));
            mpxjCalendar.setWorkingDay(Day.WEDNESDAY, this.isWorkingDay(defaultWeek.getWed()));
            mpxjCalendar.setWorkingDay(Day.THURSDAY, this.isWorkingDay(defaultWeek.getThu()));
            mpxjCalendar.setWorkingDay(Day.FRIDAY, this.isWorkingDay(defaultWeek.getFri()));
            mpxjCalendar.setWorkingDay(Day.SATURDAY, this.isWorkingDay(defaultWeek.getSat()));
            mpxjCalendar.setWorkingDay(Day.SUNDAY, this.isWorkingDay(defaultWeek.getSun()));
        }
        for (Day day : Day.values()) {
            if (!mpxjCalendar.isWorkingDay(day)) continue;
            ProjectCalendarHours hours = mpxjCalendar.addCalendarHours(day);
            hours.addRange(ProjectCalendarWeek.DEFAULT_WORKING_MORNING);
            hours.addRange(ProjectCalendarWeek.DEFAULT_WORKING_AFTERNOON);
        }
    }

    private boolean isWorkingDay(Integer value) {
        return NumberHelper.getInt(value) == 0;
    }

    private void setExceptions(ProjectCalendar mpxjCalendar, Calendars gpCalendar) {
        List<Date> dates = gpCalendar.getDate();
        for (Date date : dates) {
            this.addException(mpxjCalendar, date);
        }
    }

    private void addException(ProjectCalendar mpxjCalendar, Date date) {
        String year = date.getYear();
        if (year != null && !year.isEmpty()) {
            Calendar calendar = DateHelper.popCalendar();
            calendar.set(1, Integer.parseInt(year));
            calendar.set(2, NumberHelper.getInt(date.getMonth()));
            calendar.set(5, NumberHelper.getInt(date.getDate()));
            java.util.Date exceptionDate = calendar.getTime();
            DateHelper.pushCalendar(calendar);
            ProjectCalendarException exception = mpxjCalendar.addCalendarException(exceptionDate, exceptionDate);
            if ("WORKING_DAY".equals(date.getType())) {
                exception.addRange(ProjectCalendarWeek.DEFAULT_WORKING_MORNING);
                exception.addRange(ProjectCalendarWeek.DEFAULT_WORKING_AFTERNOON);
            }
        }
    }

    private void readResources(Project ganttProject) {
        Resources resources = ganttProject.getResources();
        this.readResourceCustomPropertyDefinitions(resources);
        this.readRoleDefinitions(ganttProject);
        for (Resource gpResource : resources.getResource()) {
            this.readResource(gpResource);
        }
    }

    private void readResourceCustomPropertyDefinitions(Resources gpResources) {
        CustomField field = this.m_projectFile.getCustomFields().getCustomField(ResourceField.TEXT1);
        field.setAlias("Phone");
        for (CustomPropertyDefinition definition : gpResources.getCustomPropertyDefinition()) {
            String type = definition.getType();
            FieldType fieldType = RESOURCE_PROPERTY_TYPES.get(type).getField();
            if (fieldType == null) {
                fieldType = RESOURCE_PROPERTY_TYPES.get("text").getField();
            }
            if (fieldType == null) continue;
            field = this.m_projectFile.getCustomFields().getCustomField(fieldType);
            field.setAlias(definition.getName());
            String defaultValue = definition.getDefaultValue();
            if (defaultValue != null && defaultValue.isEmpty()) {
                defaultValue = null;
            }
            this.m_resourcePropertyDefinitions.put(definition.getId(), new Pair<FieldType, String>(fieldType, defaultValue));
        }
    }

    private void readTaskCustomPropertyDefinitions(Tasks gpTasks) {
        for (Taskproperty definition : gpTasks.getTaskproperties().getTaskproperty()) {
            if (!"custom".equals(definition.getType())) continue;
            String type = definition.getValuetype();
            FieldType fieldType = TASK_PROPERTY_TYPES.get(type).getField();
            if (fieldType == null) {
                fieldType = TASK_PROPERTY_TYPES.get("text").getField();
            }
            if (fieldType == null) continue;
            CustomField field = this.m_projectFile.getCustomFields().getCustomField(fieldType);
            field.setAlias(definition.getName());
            String defaultValue = definition.getDefaultvalue();
            if (defaultValue != null && defaultValue.isEmpty()) {
                defaultValue = null;
            }
            this.m_taskPropertyDefinitions.put(definition.getId(), new Pair<FieldType, String>(fieldType, defaultValue));
        }
    }

    private void readRoleDefinitions(Project gpProject) {
        this.m_roleDefinitions.put("Default:1", "project manager");
        for (Roles roles : gpProject.getRoles()) {
            if ("Default".equals(roles.getRolesetName())) continue;
            for (Role role : roles.getRole()) {
                this.m_roleDefinitions.put(role.getId(), role.getName());
            }
        }
    }

    private void readResource(Resource gpResource) {
        net.sf.mpxj.Resource mpxjResource = this.m_projectFile.addResource();
        mpxjResource.setUniqueID(NumberHelper.getInt(gpResource.getId()) + 1);
        mpxjResource.setName(gpResource.getName());
        mpxjResource.setEmailAddress(gpResource.getContacts());
        mpxjResource.setText(1, gpResource.getPhone());
        mpxjResource.setGroup(this.m_roleDefinitions.get(gpResource.getFunction()));
        Rate gpRate = gpResource.getRate();
        if (gpRate != null) {
            mpxjResource.setStandardRate(new net.sf.mpxj.Rate(gpRate.getValueAttribute(), TimeUnit.DAYS));
        }
        this.readResourceCustomFields(gpResource, mpxjResource);
        this.m_eventManager.fireResourceReadEvent(mpxjResource);
    }

    private void readResourceCustomFields(Resource gpResource, net.sf.mpxj.Resource mpxjResource) {
        HashMap<FieldType, Object> customFields = new HashMap<FieldType, Object>();
        for (Pair<FieldType, String> pair : this.m_resourcePropertyDefinitions.values()) {
            customFields.put(pair.getFirst(), pair.getSecond());
        }
        for (CustomResourceProperty customResourceProperty : gpResource.getCustomProperty()) {
            Object result;
            Pair<FieldType, String> definition = this.m_resourcePropertyDefinitions.get(customResourceProperty.getDefinitionId());
            if (definition == null) continue;
            String value = customResourceProperty.getValueAttribute();
            if (value.isEmpty()) {
                value = null;
            }
            if (value == null) continue;
            switch (definition.getFirst().getDataType()) {
                case NUMERIC: {
                    if (value.indexOf(46) == -1) {
                        result = Integer.valueOf(value);
                        break;
                    }
                    result = Double.valueOf(value);
                    break;
                }
                case DATE: {
                    try {
                        result = this.m_localeDateFormat.parse(value);
                    }
                    catch (ParseException ex) {
                        result = null;
                    }
                    break;
                }
                case BOOLEAN: {
                    result = value.equals("true");
                    break;
                }
                default: {
                    result = value;
                }
            }
            if (result == null) continue;
            customFields.put(definition.getFirst(), result);
        }
        for (Map.Entry entry : customFields.entrySet()) {
            if (entry.getValue() == null) continue;
            mpxjResource.set((FieldType)entry.getKey(), entry.getValue());
        }
    }

    private void readTaskCustomFields(net.sf.mpxj.ganttproject.schema.Task gpTask, Task mpxjTask) {
        HashMap<FieldType, Object> customFields = new HashMap<FieldType, Object>();
        for (Pair<FieldType, String> pair : this.m_taskPropertyDefinitions.values()) {
            customFields.put(pair.getFirst(), pair.getSecond());
        }
        for (CustomTaskProperty customTaskProperty : gpTask.getCustomproperty()) {
            Object result;
            Pair<FieldType, String> definition = this.m_taskPropertyDefinitions.get(customTaskProperty.getTaskpropertyId());
            if (definition == null) continue;
            String value = customTaskProperty.getValueAttribute();
            if (value.isEmpty()) {
                value = null;
            }
            if (value == null) continue;
            switch (definition.getFirst().getDataType()) {
                case NUMERIC: {
                    if (value.indexOf(46) == -1) {
                        result = Integer.valueOf(value);
                        break;
                    }
                    result = Double.valueOf(value);
                    break;
                }
                case DATE: {
                    try {
                        result = this.m_dateFormat.parse(value);
                    }
                    catch (ParseException ex) {
                        result = null;
                    }
                    break;
                }
                case BOOLEAN: {
                    result = value.equals("true");
                    break;
                }
                default: {
                    result = value;
                }
            }
            if (result == null) continue;
            customFields.put(definition.getFirst(), result);
        }
        for (Map.Entry entry : customFields.entrySet()) {
            if (entry.getValue() == null) continue;
            mpxjTask.set((FieldType)entry.getKey(), entry.getValue());
        }
    }

    private void readTasks(Project gpProject) {
        Tasks tasks = gpProject.getTasks();
        this.readTaskCustomPropertyDefinitions(tasks);
        for (net.sf.mpxj.ganttproject.schema.Task task : tasks.getTask()) {
            this.readTask(this.m_projectFile, task);
        }
    }

    private void readTask(ChildTaskContainer mpxjParent, net.sf.mpxj.ganttproject.schema.Task gpTask) {
        Task mpxjTask = mpxjParent.addTask();
        mpxjTask.setUniqueID(NumberHelper.getInt(gpTask.getId()) + 1);
        mpxjTask.setName(gpTask.getName());
        mpxjTask.setPercentageComplete(gpTask.getComplete());
        mpxjTask.setPriority(this.getPriority(gpTask.getPriority()));
        mpxjTask.setHyperlink(gpTask.getWebLink());
        Duration duration = Duration.getInstance(NumberHelper.getDouble(gpTask.getDuration()), TimeUnit.DAYS);
        mpxjTask.setDuration(duration);
        if (duration.getDuration() == 0.0) {
            mpxjTask.setMilestone(true);
        } else {
            mpxjTask.setStart(gpTask.getStart());
            mpxjTask.setFinish(this.m_mpxjCalendar.getDate(gpTask.getStart(), mpxjTask.getDuration(), false));
        }
        mpxjTask.setConstraintDate(gpTask.getThirdDate());
        if (mpxjTask.getConstraintDate() != null) {
            mpxjTask.setConstraintType(ConstraintType.START_NO_EARLIER_THAN);
        }
        this.readTaskCustomFields(gpTask, mpxjTask);
        this.m_eventManager.fireTaskReadEvent(mpxjTask);
        for (net.sf.mpxj.ganttproject.schema.Task childTask : gpTask.getTask()) {
            this.readTask(mpxjTask, childTask);
        }
    }

    private Priority getPriority(Integer gpPriority) {
        int index;
        int result = gpPriority == null ? 500 : ((index = gpPriority.intValue()) < 0 || index >= PRIORITY.length ? 500 : PRIORITY[index]);
        return Priority.getInstance(result);
    }

    private void readRelationships(Project gpProject) {
        for (net.sf.mpxj.ganttproject.schema.Task gpTask : gpProject.getTasks().getTask()) {
            this.readRelationships(gpTask);
        }
    }

    private void readRelationships(net.sf.mpxj.ganttproject.schema.Task gpTask) {
        for (Depend depend : gpTask.getDepend()) {
            Task task1 = this.m_projectFile.getTaskByUniqueID(NumberHelper.getInt(gpTask.getId()) + 1);
            Task task2 = this.m_projectFile.getTaskByUniqueID(NumberHelper.getInt(depend.getId()) + 1);
            if (task1 == null || task2 == null) continue;
            Duration lag = Duration.getInstance(NumberHelper.getInt(depend.getDifference()), TimeUnit.DAYS);
            Relation relation = task2.addPredecessor(task1, this.getRelationType(depend.getType()), lag);
            this.m_eventManager.fireRelationReadEvent(relation);
        }
    }

    private RelationType getRelationType(Integer gpType) {
        int index;
        RelationType result = null;
        if (gpType != null && (index = NumberHelper.getInt(gpType)) > 0 && index < RELATION.length) {
            result = RELATION[index];
        }
        if (result == null) {
            result = RelationType.FINISH_START;
        }
        return result;
    }

    private void readResourceAssignments(Project gpProject) {
        Allocations allocations = gpProject.getAllocations();
        if (allocations != null) {
            for (Allocation allocation : allocations.getAllocation()) {
                this.readResourceAssignment(allocation);
            }
        }
    }

    private void readResourceAssignment(Allocation gpAllocation) {
        Integer taskID = NumberHelper.getInt(gpAllocation.getTaskId()) + 1;
        Integer resourceID = NumberHelper.getInt(gpAllocation.getResourceId()) + 1;
        Task task = this.m_projectFile.getTaskByUniqueID(taskID);
        net.sf.mpxj.Resource resource = this.m_projectFile.getResourceByUniqueID(resourceID);
        if (task != null && resource != null) {
            ResourceAssignment mpxjAssignment = task.addResourceAssignment(resource);
            mpxjAssignment.setUnits(gpAllocation.getLoad());
            this.m_eventManager.fireAssignmentReadEvent(mpxjAssignment);
        }
    }

    static {
        CustomProperty numeric = new CustomProperty(ResourceFieldLists.CUSTOM_NUMBER);
        RESOURCE_PROPERTY_TYPES.put("int", numeric);
        RESOURCE_PROPERTY_TYPES.put("double", numeric);
        RESOURCE_PROPERTY_TYPES.put("text", new CustomProperty(ResourceFieldLists.CUSTOM_TEXT, 1));
        RESOURCE_PROPERTY_TYPES.put("date", new CustomProperty(ResourceFieldLists.CUSTOM_DATE));
        RESOURCE_PROPERTY_TYPES.put("boolean", new CustomProperty(ResourceFieldLists.CUSTOM_FLAG));
        TASK_PROPERTY_TYPES = new HashMap<String, CustomProperty>();
        numeric = new CustomProperty(TaskFieldLists.CUSTOM_NUMBER);
        TASK_PROPERTY_TYPES.put("int", numeric);
        TASK_PROPERTY_TYPES.put("double", numeric);
        TASK_PROPERTY_TYPES.put("text", new CustomProperty(TaskFieldLists.CUSTOM_TEXT));
        TASK_PROPERTY_TYPES.put("date", new CustomProperty(TaskFieldLists.CUSTOM_DATE));
        TASK_PROPERTY_TYPES.put("boolean", new CustomProperty(TaskFieldLists.CUSTOM_FLAG));
        PRIORITY = new int[]{400, 500, 600, 100, 900};
        RELATION = new RelationType[]{null, RelationType.START_START, RelationType.FINISH_START, RelationType.FINISH_FINISH, RelationType.START_FINISH};
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance("net.sf.mpxj.ganttproject.schema", GanttProjectReader.class.getClassLoader());
        }
        catch (JAXBException ex) {
            CONTEXT_EXCEPTION = ex;
            CONTEXT = null;
        }
    }
}

