/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.fasttrack;

import java.text.DecimalFormat;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.fasttrack.FastTrackData;
import net.sf.mpxj.fasttrack.UnexpectedStructureException;

final class FastTrackUtility {
    private static final long NULL_DOUBLE = 4128101167230658355L;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    FastTrackUtility() {
    }

    public static final void validateSize(int size) {
        if (size < 0 || size > 100000) {
            throw new UnexpectedStructureException();
        }
    }

    public static final void validateOffset(byte[] buffer, int offset) {
        if (offset >= buffer.length) {
            throw new UnexpectedStructureException();
        }
    }

    public static String getString(byte[] buffer, int offset, int length) {
        try {
            return new String(buffer, offset, length, FastTrackData.getInstance().getCharset());
        }
        catch (StringIndexOutOfBoundsException ex) {
            throw new UnexpectedStructureException();
        }
    }

    public static final int getInt(byte[] data, int offset) {
        int result = 0;
        int i2 = offset;
        for (int shiftBy = 0; shiftBy < 32; shiftBy += 8) {
            result |= (data[i2] & 0xFF) << shiftBy;
            ++i2;
        }
        return result;
    }

    public static final int getShort(byte[] data, int offset) {
        int result = 0;
        int i2 = offset;
        for (int shiftBy = 0; shiftBy < 16; shiftBy += 8) {
            result |= (data[i2] & 0xFF) << shiftBy;
            ++i2;
        }
        return result;
    }

    public static final long getLong(byte[] data, int offset) {
        if (data.length != 8) {
            throw new UnexpectedStructureException();
        }
        long result = 0L;
        int i2 = offset;
        for (int shiftBy = 0; shiftBy < 64; shiftBy += 8) {
            result |= (long)(data[i2] & 0xFF) << shiftBy;
            ++i2;
        }
        return result;
    }

    public static final Double getDouble(byte[] data, int offset) {
        double doubleValue;
        Double result = null;
        long longValue = FastTrackUtility.getLong(data, offset);
        if (longValue != 4128101167230658355L && !Double.isNaN(doubleValue = Double.longBitsToDouble(longValue))) {
            result = doubleValue;
        }
        return result;
    }

    public static final int getByte(byte[] data, int offset) {
        int result = data[offset] & 0xFF;
        return result;
    }

    public static final TimeUnit getTimeUnit(int value) {
        TimeUnit result = null;
        switch (value) {
            case 1: {
                result = TimeUnit.ELAPSED_DAYS;
                break;
            }
            case 2: {
                result = TimeUnit.HOURS;
                break;
            }
            case 4: {
                result = TimeUnit.DAYS;
                break;
            }
            case 6: {
                result = TimeUnit.WEEKS;
                break;
            }
            case 8: 
            case 10: {
                result = TimeUnit.MONTHS;
                break;
            }
            case 12: {
                result = TimeUnit.YEARS;
                break;
            }
        }
        return result;
    }

    public static int skipToNextMatchingShort(byte[] buffer, int offset, int value) {
        int nextOffset = offset;
        while (FastTrackUtility.getShort(buffer, nextOffset) != value) {
            ++nextOffset;
        }
        return nextOffset += 2;
    }

    public static final String hexdump(byte[] buffer, int offset, int length, boolean ascii, int columns, String prefix) {
        StringBuilder sb2 = new StringBuilder();
        if (buffer != null) {
            DecimalFormat df = new DecimalFormat("00000");
            for (int index = offset; index < offset + length; index += columns) {
                if (index + columns > offset + length) {
                    columns = offset + length - index;
                }
                sb2.append(prefix);
                sb2.append(df.format(index - offset));
                sb2.append(":");
                sb2.append(FastTrackUtility.hexdump(buffer, index, columns, ascii));
                sb2.append('\n');
            }
        }
        return sb2.toString();
    }

    public static final String hexdump(byte[] buffer, int offset, int length, boolean ascii) {
        StringBuilder sb2 = new StringBuilder();
        if (buffer != null) {
            int loop;
            int count = offset + length;
            for (loop = offset; loop < count; ++loop) {
                sb2.append(" ");
                sb2.append(HEX_DIGITS[(buffer[loop] & 0xF0) >> 4]);
                sb2.append(HEX_DIGITS[buffer[loop] & 0xF]);
            }
            if (ascii) {
                sb2.append("   ");
                for (loop = offset; loop < count; ++loop) {
                    char c2 = (char)buffer[loop];
                    if (c2 > '\u00c8' || c2 < '\u001b') {
                        c2 = ' ';
                    }
                    sb2.append(c2);
                }
            }
        }
        return sb2.toString();
    }
}

