/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.explorer;

import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.table.DefaultTableModel;
import net.sf.mpxj.Duration;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.StreamHelper;
import net.sf.mpxj.explorer.HexDumpModel;
import net.sf.mpxj.mpp.MPPUtility;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

public class HexDumpController {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final HexDumpModel m_model;

    public HexDumpController(HexDumpModel model) {
        this.m_model = model;
        model.addPropertyChangeListener("columns", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                HexDumpController.this.updateTables();
            }
        });
        model.addPropertyChangeListener("offset", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                HexDumpController.this.updateTables();
            }
        });
        model.addPropertyChangeListener("selectedCell", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                HexDumpController.this.updateSelection();
            }
        });
    }

    public void viewDocument(DocumentEntry entry) {
        DocumentInputStream is = null;
        try {
            is = new DocumentInputStream(entry);
            byte[] data = new byte[((InputStream)is).available()];
            ((InputStream)is).read(data);
            this.m_model.setData(data);
            this.updateTables();
        }
        catch (IOException ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                StreamHelper.closeQuietly(is);
                throw throwable;
            }
        }
        StreamHelper.closeQuietly(is);
    }

    protected void updateTables() {
        byte[] data = this.m_model.getData();
        int columns = this.m_model.getColumns();
        int rows = data.length / columns + 1;
        int offset = this.m_model.getOffset();
        Object[][] hexData = new String[rows][columns];
        Object[][] asciiData = new String[rows][columns];
        int row = 0;
        int column = 0;
        StringBuilder hexValue = new StringBuilder();
        for (int index = offset; index < data.length; ++index) {
            byte value = data[index];
            hexValue.setLength(0);
            hexValue.append(HEX_DIGITS[(value & 0xF0) >> 4]);
            hexValue.append(HEX_DIGITS[value & 0xF]);
            char c2 = (char)value;
            if (c2 > '\u00c8' || c2 < '\u001b') {
                c2 = ' ';
            }
            hexData[row][column] = hexValue.toString();
            asciiData[row][column] = Character.toString(c2);
            if (++column != columns) continue;
            column = 0;
            ++row;
        }
        Object[] columnHeadings = new String[columns];
        DefaultTableModel hexTableModel = new DefaultTableModel(hexData, columnHeadings){

            @Override
            public boolean isCellEditable(int r2, int c2) {
                return false;
            }
        };
        DefaultTableModel asciiTableModel = new DefaultTableModel(asciiData, columnHeadings){

            @Override
            public boolean isCellEditable(int r2, int c2) {
                return false;
            }
        };
        this.m_model.setSizeValueLabel(Integer.toString(data.length));
        this.m_model.setHexTableModel(hexTableModel);
        this.m_model.setAsciiTableModel(asciiTableModel);
        this.m_model.setCurrentSelectionIndex(0);
        this.m_model.setPreviousSelectionIndex(0);
    }

    protected void updateSelection() {
        Date timestamp;
        byte[] data = this.m_model.getData();
        int offset = this.m_model.getOffset();
        Point selectedCell = this.m_model.getSelectedCell();
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
        SimpleDateFormat timestampFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        int selectionIndex = selectedCell.y * this.m_model.getColumns() + selectedCell.x;
        String selectionLabel = selectedCell.y + "," + selectedCell.x;
        String differenceLabel = Integer.toString(Math.abs(this.m_model.getCurrentSelectionIndex() - selectionIndex));
        String shortValueLabel = "";
        String longSixValueLabel = "";
        String longValueLabel = "";
        String doubleValueLabel = "";
        String durationValueLabel = "";
        String timeUnitsValueLabel = "";
        String guidValueLabel = "";
        String percentageValueLabel = "";
        String dateValueLabel = "";
        String timeValueLabel = "";
        String timestampValueLabel = "";
        String workUnitsValueLabel = "";
        if (selectionIndex + offset + 2 <= data.length) {
            Date date;
            shortValueLabel = Integer.toString(MPPUtility.getShort(data, selectionIndex + offset));
            timeUnitsValueLabel = MPPUtility.getDurationTimeUnits(MPPUtility.getShort(data, selectionIndex + offset)).toString();
            Double value = MPPUtility.getPercentage(data, selectionIndex + offset);
            if (value != null) {
                percentageValueLabel = value.toString();
            }
            if ((date = MPPUtility.getDate(data, selectionIndex + offset)) != null) {
                dateValueLabel = dateFormat.format(date);
            }
            timeValueLabel = timeFormat.format(MPPUtility.getTime(data, selectionIndex + offset));
        }
        workUnitsValueLabel = MPPUtility.getWorkTimeUnits(MPPUtility.getByte(data, selectionIndex + offset)).toString();
        if (selectionIndex + offset + 4 <= data.length && (timestamp = MPPUtility.getTimestamp(data, selectionIndex + offset)) != null) {
            timestampValueLabel = timestampFormat.format(timestamp);
        }
        if (selectionIndex + offset + 6 <= data.length) {
            longSixValueLabel = Long.toString(MPPUtility.getLong6(data, selectionIndex + offset));
        }
        if (selectionIndex + offset + 8 <= data.length) {
            longValueLabel = Long.toString(MPPUtility.getLong(data, selectionIndex + offset));
            doubleValueLabel = Double.toString(MPPUtility.getDouble(data, selectionIndex + offset));
            durationValueLabel = Duration.getInstance(MPPUtility.getDouble(data, selectionIndex + offset) / 60000.0, TimeUnit.HOURS).toString();
        }
        if (selectionIndex + offset + 16 <= data.length) {
            guidValueLabel = MPPUtility.getGUID(data, selectionIndex + offset).toString().toUpperCase();
        }
        this.m_model.setPreviousSelectionIndex(this.m_model.getCurrentSelectionIndex());
        this.m_model.setCurrentSelectionIndex(selectionIndex);
        this.m_model.setPreviousSelectionValueLabel(this.m_model.getCurrentSelectionValueLabel());
        this.m_model.setCurrentSelectionValueLabel(selectionLabel);
        this.m_model.setSelectionDifferenceValueLabel(differenceLabel);
        this.m_model.setShortValueLabel(shortValueLabel);
        this.m_model.setLongSixValueLabel(longSixValueLabel);
        this.m_model.setLongValueLabel(longValueLabel);
        this.m_model.setDoubleValueLabel(doubleValueLabel);
        this.m_model.setDurationValueLabel(durationValueLabel);
        this.m_model.setTimeUnitsValueLabel(timeUnitsValueLabel);
        this.m_model.setGuidValueLabel(guidValueLabel);
        this.m_model.setPercentageValueLabel(percentageValueLabel);
        this.m_model.setDateValueLabel(dateValueLabel);
        this.m_model.setTimeValueLabel(timeValueLabel);
        this.m_model.setTimestampValueLabel(timestampValueLabel);
        this.m_model.setWorkUnitsValueLabel(workUnitsValueLabel);
    }
}

