/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.conceptdraw;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Rate;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.AlphanumComparator;
import net.sf.mpxj.conceptdraw.NamespaceFilter;
import net.sf.mpxj.conceptdraw.schema.Document;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.reader.AbstractProjectReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class ConceptDrawProjectReader
extends AbstractProjectReader {
    private ProjectFile m_projectFile;
    private EventManager m_eventManager;
    private List<ProjectListener> m_projectListeners;
    private Map<Integer, ProjectCalendar> m_calendarMap;
    private Map<Integer, Task> m_taskIdMap;
    private double m_workHoursPerDay;
    private static final int HOURS_PER_DAY = 24;
    private static final int MINUTES_PER_DAY = 1440;
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;

    @Override
    public void addProjectListener(ProjectListener listener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(listener);
    }

    @Override
    public ProjectFile read(InputStream stream) throws MPXJException {
        try {
            this.m_projectFile = new ProjectFile();
            this.m_eventManager = this.m_projectFile.getEventManager();
            this.m_calendarMap = new HashMap<Integer, ProjectCalendar>();
            this.m_taskIdMap = new HashMap<Integer, Task>();
            ProjectConfig config = this.m_projectFile.getProjectConfig();
            config.setAutoResourceUniqueID(false);
            config.setAutoResourceID(false);
            this.m_projectFile.getProjectProperties().setFileApplication("ConceptDraw PROJECT");
            this.m_projectFile.getProjectProperties().setFileType("CDP");
            this.m_eventManager.addProjectListeners(this.m_projectListeners);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            if (CONTEXT == null) {
                throw CONTEXT_EXCEPTION;
            }
            Unmarshaller unmarshaller = CONTEXT.createUnmarshaller();
            NamespaceFilter filter = new NamespaceFilter();
            filter.setParent(xmlReader);
            UnmarshallerHandler unmarshallerHandler = unmarshaller.getUnmarshallerHandler();
            filter.setContentHandler(unmarshallerHandler);
            filter.parse(new InputSource(new InputStreamReader(stream)));
            Document cdp = (Document)unmarshallerHandler.getResult();
            this.readProjectProperties(cdp);
            this.readCalendars(cdp);
            this.readResources(cdp);
            this.readTasks(cdp);
            this.readRelationships(cdp);
            config.updateUniqueCounters();
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        catch (ParserConfigurationException ex) {
            throw new MPXJException("Failed to parse file", ex);
        }
        catch (JAXBException ex) {
            throw new MPXJException("Failed to parse file", ex);
        }
        catch (SAXException ex) {
            throw new MPXJException("Failed to parse file", ex);
        }
        catch (IOException ex) {
            throw new MPXJException("Failed to parse file", ex);
        }
        finally {
            this.m_projectFile = null;
            this.m_eventManager = null;
            this.m_projectListeners = null;
            this.m_calendarMap = null;
            this.m_taskIdMap = null;
        }
    }

    private void readProjectProperties(Document cdp) {
        Document.WorkspaceProperties props = cdp.getWorkspaceProperties();
        ProjectProperties mpxjProps = this.m_projectFile.getProjectProperties();
        mpxjProps.setSymbolPosition(props.getCurrencyPosition());
        mpxjProps.setCurrencyDigits(props.getCurrencyDigits());
        mpxjProps.setCurrencySymbol(props.getCurrencySymbol());
        mpxjProps.setDaysPerMonth(props.getDaysPerMonth());
        mpxjProps.setMinutesPerDay(props.getHoursPerDay());
        mpxjProps.setMinutesPerWeek(props.getHoursPerWeek());
        this.m_workHoursPerDay = mpxjProps.getMinutesPerDay().doubleValue() / 60.0;
    }

    private void readCalendars(Document cdp) {
        for (Document.Calendars.Calendar calendar : cdp.getCalendars().getCalendar()) {
            this.readCalendar(calendar);
        }
        for (Document.Calendars.Calendar calendar : cdp.getCalendars().getCalendar()) {
            ProjectCalendar child = this.m_calendarMap.get(calendar.getID());
            ProjectCalendar parent = this.m_calendarMap.get(calendar.getBaseCalendarID());
            if (parent == null) {
                this.m_projectFile.setDefaultCalendar(child);
                continue;
            }
            child.setParent(parent);
        }
    }

    private void readCalendar(Document.Calendars.Calendar calendar) {
        ProjectCalendar mpxjCalendar = this.m_projectFile.addCalendar();
        mpxjCalendar.setName(calendar.getName());
        this.m_calendarMap.put(calendar.getID(), mpxjCalendar);
        for (Document.Calendars.Calendar.WeekDays.WeekDay weekDay : calendar.getWeekDays().getWeekDay()) {
            this.readWeekDay(mpxjCalendar, weekDay);
        }
        for (Document.Calendars.Calendar.ExceptedDays.ExceptedDay exceptedDay : calendar.getExceptedDays().getExceptedDay()) {
            this.readExceptionDay(mpxjCalendar, exceptedDay);
        }
    }

    private void readWeekDay(ProjectCalendar mpxjCalendar, Document.Calendars.Calendar.WeekDays.WeekDay day) {
        if (day.isIsDayWorking()) {
            ProjectCalendarHours hours = mpxjCalendar.addCalendarHours(day.getDay());
            for (Document.Calendars.Calendar.WeekDays.WeekDay.TimePeriods.TimePeriod period : day.getTimePeriods().getTimePeriod()) {
                hours.addRange(new DateRange(period.getFrom(), period.getTo()));
            }
        }
    }

    private void readExceptionDay(ProjectCalendar mpxjCalendar, Document.Calendars.Calendar.ExceptedDays.ExceptedDay day) {
        ProjectCalendarException mpxjException = mpxjCalendar.addCalendarException(day.getDate(), day.getDate());
        if (day.isIsDayWorking()) {
            for (Document.Calendars.Calendar.ExceptedDays.ExceptedDay.TimePeriods.TimePeriod period : day.getTimePeriods().getTimePeriod()) {
                mpxjException.addRange(new DateRange(period.getFrom(), period.getTo()));
            }
        }
    }

    private void readResources(Document cdp) {
        for (Document.Resources.Resource resource : cdp.getResources().getResource()) {
            this.readResource(resource);
        }
    }

    private void readResource(Document.Resources.Resource resource) {
        Resource mpxjResource = this.m_projectFile.addResource();
        mpxjResource.setName(resource.getName());
        mpxjResource.setResourceCalendar(this.m_calendarMap.get(resource.getCalendarID()));
        mpxjResource.setStandardRate(new Rate(resource.getCost(), resource.getCostTimeUnit()));
        mpxjResource.setEmailAddress(resource.getEMail());
        mpxjResource.setGroup(resource.getGroup());
        mpxjResource.setUniqueID(resource.getID());
        mpxjResource.setNotes(resource.getNote());
        mpxjResource.setID(Integer.valueOf(resource.getOutlineNumber()));
        mpxjResource.setType(resource.getSubType() == null ? resource.getType() : resource.getSubType());
    }

    private void readTasks(Document cdp) {
        ArrayList<Document.Projects.Project> projects = new ArrayList<Document.Projects.Project>(cdp.getProjects().getProject());
        final AlphanumComparator comparator = new AlphanumComparator();
        Collections.sort(projects, new Comparator<Document.Projects.Project>(){

            @Override
            public int compare(Document.Projects.Project o1, Document.Projects.Project o2) {
                return comparator.compare(o1.getOutlineNumber(), o2.getOutlineNumber());
            }
        });
        for (Document.Projects.Project project : cdp.getProjects().getProject()) {
            this.readProject(project);
        }
    }

    private void readProject(Document.Projects.Project project) {
        Task mpxjTask = this.m_projectFile.addTask();
        mpxjTask.setBaselineCost(project.getBaselineCost());
        mpxjTask.setBaselineFinish(project.getBaselineFinishDate());
        mpxjTask.setBaselineStart(project.getBaselineStartDate());
        mpxjTask.setFinish(project.getFinishDate());
        mpxjTask.setName(project.getName());
        mpxjTask.setNotes(project.getNote());
        mpxjTask.setPriority(project.getPriority());
        mpxjTask.setStart(project.getStartDate());
        String projectIdentifier = project.getID().toString();
        mpxjTask.setGUID(UUID.nameUUIDFromBytes(projectIdentifier.getBytes()));
        ArrayList<Document.Projects.Project.Task> tasks = new ArrayList<Document.Projects.Project.Task>(project.getTask());
        final AlphanumComparator comparator = new AlphanumComparator();
        Collections.sort(tasks, new Comparator<Document.Projects.Project.Task>(){

            @Override
            public int compare(Document.Projects.Project.Task o1, Document.Projects.Project.Task o2) {
                return comparator.compare(o1.getOutlineNumber(), o2.getOutlineNumber());
            }
        });
        HashMap<String, Task> map = new HashMap<String, Task>();
        map.put("", mpxjTask);
        for (Document.Projects.Project.Task task : tasks) {
            this.readTask(projectIdentifier, map, task);
        }
    }

    private void readTask(String projectIdentifier, Map<String, Task> map, Document.Projects.Project.Task task) {
        Task parentTask = map.get(this.getParentOutlineNumber(task.getOutlineNumber()));
        Task mpxjTask = parentTask.addTask();
        TimeUnit units = task.getBaseDurationTimeUnit();
        mpxjTask.setCost(task.getActualCost());
        mpxjTask.setDuration(this.getDuration(units, task.getActualDuration()));
        mpxjTask.setFinish(task.getActualFinishDate());
        mpxjTask.setStart(task.getActualStartDate());
        mpxjTask.setBaselineDuration(this.getDuration(units, task.getBaseDuration()));
        mpxjTask.setBaselineFinish(task.getBaseFinishDate());
        mpxjTask.setBaselineCost(task.getBaselineCost());
        mpxjTask.setBaselineStart(task.getBaseStartDate());
        mpxjTask.setPercentageComplete(task.getComplete());
        mpxjTask.setDeadline(task.getDeadlineDate());
        mpxjTask.setName(task.getName());
        mpxjTask.setNotes(task.getNote());
        mpxjTask.setPriority(task.getPriority());
        mpxjTask.setType(task.getSchedulingType());
        if (task.isIsMilestone()) {
            mpxjTask.setMilestone(true);
            mpxjTask.setDuration(Duration.getInstance(0, TimeUnit.HOURS));
            mpxjTask.setBaselineDuration(Duration.getInstance(0, TimeUnit.HOURS));
        }
        String taskIdentifier = projectIdentifier + "." + task.getID();
        this.m_taskIdMap.put(task.getID(), mpxjTask);
        mpxjTask.setGUID(UUID.nameUUIDFromBytes(taskIdentifier.getBytes()));
        map.put(task.getOutlineNumber(), mpxjTask);
        for (Document.Projects.Project.Task.ResourceAssignments.ResourceAssignment assignment : task.getResourceAssignments().getResourceAssignment()) {
            this.readResourceAssignment(mpxjTask, assignment);
        }
    }

    private void readResourceAssignment(Task task, Document.Projects.Project.Task.ResourceAssignments.ResourceAssignment assignment) {
        Resource resource = this.m_projectFile.getResourceByUniqueID(assignment.getResourceID());
        if (resource != null) {
            ResourceAssignment mpxjAssignment = task.addResourceAssignment(resource);
            mpxjAssignment.setUniqueID(assignment.getID());
            mpxjAssignment.setWork(Duration.getInstance(assignment.getManHour() * this.m_workHoursPerDay, TimeUnit.HOURS));
            mpxjAssignment.setUnits(assignment.getUse());
        }
    }

    private void readRelationships(Document cdp) {
        for (Document.Links.Link link : cdp.getLinks().getLink()) {
            this.readRelationship(link);
        }
    }

    private void readRelationship(Document.Links.Link link) {
        Task sourceTask = this.m_taskIdMap.get(link.getSourceTaskID());
        Task destinationTask = this.m_taskIdMap.get(link.getDestinationTaskID());
        if (sourceTask != null && destinationTask != null) {
            Duration lag = this.getDuration(link.getLagUnit(), link.getLag());
            RelationType type = link.getType();
            Relation relation = destinationTask.addPredecessor(sourceTask, type, lag);
            relation.setUniqueID(link.getID());
        }
    }

    private Duration getDuration(TimeUnit units, Double duration) {
        Duration result = null;
        if (duration != null) {
            double durationValue = duration * 100.0;
            switch (units) {
                case MINUTES: {
                    durationValue *= 1440.0;
                    break;
                }
                case HOURS: {
                    durationValue *= 24.0;
                    break;
                }
                case DAYS: {
                    durationValue *= 3.0;
                    break;
                }
                case WEEKS: {
                    durationValue *= 0.6;
                    break;
                }
                case MONTHS: {
                    durationValue *= 0.15;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported time units " + units);
                }
            }
            durationValue = (double)Math.round(durationValue) / 100.0;
            result = Duration.getInstance(durationValue, units);
        }
        return result;
    }

    private String getParentOutlineNumber(String outlineNumber) {
        int index = outlineNumber.lastIndexOf(46);
        String result = index == -1 ? "" : outlineNumber.substring(0, index);
        return result;
    }

    static {
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance("net.sf.mpxj.conceptdraw.schema", ConceptDrawProjectReader.class.getClassLoader());
        }
        catch (JAXBException ex) {
            CONTEXT_EXCEPTION = ex;
            CONTEXT = null;
        }
    }
}

