/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import net.sf.mpxj.common.FileHelper;

public class InputStreamHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeStreamToTempFile(InputStream inputStream, String tempFileSuffix) throws IOException {
        try (FileOutputStream outputStream = null;){
            int bytesRead;
            File file = File.createTempFile("mpxj", tempFileSuffix);
            outputStream = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            File file2 = file;
            return file2;
        }
    }

    public static File writeZipStreamToTempDir(InputStream inputStream) throws IOException {
        File dir;
        block2: {
            dir = FileHelper.createTempDir();
            try {
                InputStreamHelper.processZipStream(dir, inputStream);
            }
            catch (ZipException ex) {
                if (ex.getMessage().equals("only DEFLATED entries can have EXT descriptor")) break block2;
                throw ex;
            }
        }
        return dir;
    }

    private static void processZipStream(File dir, InputStream inputStream) throws IOException {
        ZipEntry entry;
        ZipInputStream zip = new ZipInputStream(inputStream);
        while ((entry = zip.getNextEntry()) != null) {
            int length;
            File file = new File(dir, entry.getName());
            if (entry.isDirectory()) {
                FileHelper.mkdirsQuietly(file);
                continue;
            }
            File parent = file.getParentFile();
            if (parent != null) {
                FileHelper.mkdirsQuietly(parent);
            }
            FileOutputStream fos = new FileOutputStream(file);
            byte[] bytes = new byte[1024];
            while ((length = zip.read(bytes)) >= 0) {
                fos.write(bytes, 0, length);
            }
            fos.close();
        }
    }
}

