/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.common;

import java.util.Comparator;

public class AlphanumComparator
implements Comparator<String> {
    private final boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private final String getChunk(String s2, int slength, int marker) {
        StringBuilder chunk = new StringBuilder();
        char c2 = s2.charAt(marker);
        chunk.append(c2);
        ++marker;
        if (this.isDigit(c2)) {
            while (marker < slength && this.isDigit(c2 = s2.charAt(marker))) {
                chunk.append(c2);
                ++marker;
            }
        } else {
            while (marker < slength && !this.isDigit(c2 = s2.charAt(marker))) {
                chunk.append(c2);
                ++marker;
            }
        }
        return chunk.toString();
    }

    @Override
    public int compare(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return 0;
        }
        int thisMarker = 0;
        int thatMarker = 0;
        int s1Length = s1.length();
        int s2Length = s2.length();
        while (thisMarker < s1Length && thatMarker < s2Length) {
            String thisChunk = this.getChunk(s1, s1Length, thisMarker);
            thisMarker += thisChunk.length();
            String thatChunk = this.getChunk(s2, s2Length, thatMarker);
            thatMarker += thatChunk.length();
            int result = 0;
            if (this.isDigit(thisChunk.charAt(0)) && this.isDigit(thatChunk.charAt(0))) {
                int thisChunkLength = thisChunk.length();
                result = thisChunkLength - thatChunk.length();
                if (result == 0) {
                    for (int i2 = 0; i2 < thisChunkLength; ++i2) {
                        result = thisChunk.charAt(i2) - thatChunk.charAt(i2);
                        if (result == 0) continue;
                        return result;
                    }
                }
            } else {
                result = thisChunk.compareTo(thatChunk);
            }
            if (result == 0) continue;
            return result;
        }
        return s1Length - s2Length;
    }
}

