/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.asta;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import net.sf.mpxj.common.DateHelper;

final class DatatypeConverter {
    private static final ThreadLocal<DateFormat> TIMESTAMP_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyyMMdd HHmmss");
        }
    };
    private static final ThreadLocal<DateFormat> DATE_FORMAT1 = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyyMMdd 0");
        }
    };
    private static final ThreadLocal<DateFormat> DATE_FORMAT2 = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyyMMdd");
        }
    };
    private static final ThreadLocal<DateFormat> TIME_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("HHmmss");
        }
    };
    private static final ThreadLocal<DecimalFormat> DOUBLE_FORMAT = new ThreadLocal<DecimalFormat>(){

        @Override
        protected DecimalFormat initialValue() {
            return new DecimalFormat("#.#E0");
        }
    };
    private static final long JAVA_EPOCH = -2208988800000L;
    private static final long ASTA_EPOCH = 2415021L;

    DatatypeConverter() {
    }

    public static String parseString(String value) {
        if (value != null) {
            if (!value.isEmpty() && value.charAt(0) == '<') {
                value = value.substring(1, value.length() - 1);
            }
            if (!value.isEmpty() && value.charAt(0) == '\"') {
                value = value.substring(1, value.length() - 1);
            }
        }
        return value;
    }

    public static Number parseDouble(String value) throws ParseException {
        Number result = null;
        if ((value = DatatypeConverter.parseString(value)) != null && !value.isEmpty() && !value.equals("-1 -1")) {
            int index = value.indexOf("E+");
            if (index != -1) {
                value = value.substring(0, index) + 'E' + value.substring(index + 2, value.length());
            }
            result = value.indexOf(69) != -1 ? (Number)DOUBLE_FORMAT.get().parse(value) : (Number)Double.valueOf(value);
        }
        return result;
    }

    public static Boolean parseBoolean(String value) throws ParseException {
        Boolean result = null;
        Integer number = DatatypeConverter.parseInteger(value);
        if (number != null) {
            result = number == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        return result;
    }

    public static Integer parseInteger(String value) throws ParseException {
        Integer result = null;
        if (value.length() > 0 && value.indexOf(32) == -1) {
            if (value.indexOf(46) == -1) {
                result = Integer.valueOf(value);
            } else {
                Number n2 = DatatypeConverter.parseDouble(value);
                result = n2.intValue();
            }
        }
        return result;
    }

    public static Date parseEpochTimestamp(String value) {
        Date result = null;
        if (value.length() > 0 && !value.equals("-1 -1")) {
            Calendar cal = DateHelper.popCalendar(-2208988800000L);
            int index = value.indexOf(32);
            if (index == -1) {
                if (value.length() < 6) {
                    value = "000000" + value;
                    value = value.substring(value.length() - 6);
                }
                int hours = Integer.parseInt(value.substring(0, 2));
                int minutes = Integer.parseInt(value.substring(2, 4));
                int seconds = Integer.parseInt(value.substring(4));
                cal.set(10, hours);
                cal.set(12, minutes);
                cal.set(13, seconds);
            } else {
                long astaDays = Long.parseLong(value.substring(0, index));
                int astaSeconds = Integer.parseInt(value.substring(index + 1));
                cal.add(6, (int)(astaDays - 2415021L));
                cal.set(14, 0);
                cal.set(13, 0);
                cal.set(10, 0);
                cal.add(13, astaSeconds);
            }
            result = cal.getTime();
            DateHelper.pushCalendar(cal);
        }
        return result;
    }

    public static Date parseBasicTimestamp(String value) throws ParseException {
        Date result = null;
        if (value.length() > 0 && !value.equals("-1 -1") && !value.equals("0")) {
            DateFormat df;
            if (value.endsWith(" 0")) {
                df = DATE_FORMAT1.get();
            } else if (value.indexOf(32) == -1) {
                df = DATE_FORMAT2.get();
            } else {
                df = TIMESTAMP_FORMAT.get();
                int timeIndex = value.indexOf(32) + 1;
                if (timeIndex + 6 > value.length()) {
                    String time = value.substring(timeIndex);
                    value = value.substring(0, timeIndex) + "0" + time;
                }
            }
            result = df.parse(value);
        }
        return result;
    }

    public static Date parseBasicTime(String value) throws ParseException {
        Date result = null;
        if (value.length() > 0 && !value.equals("0")) {
            value = "000000" + value;
            value = value.substring(value.length() - 6);
            result = TIME_FORMAT.get().parse(value);
        }
        return result;
    }
}

