/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.asta;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.asta.AstaDatabaseFileReader;
import net.sf.mpxj.asta.AstaTextFileReader;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.reader.AbstractProjectReader;
import net.sf.mpxj.reader.ProjectReader;

public final class AstaFileReader
extends AbstractProjectReader {
    private List<ProjectListener> m_projectListeners;
    private static final String SQLITE_TEXT = "SQLite format";

    @Override
    public void addProjectListener(ProjectListener listener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(listener);
    }

    @Override
    public ProjectFile read(InputStream inputStream) throws MPXJException {
        try {
            BufferedInputStream is = new BufferedInputStream(inputStream);
            is.mark(100);
            byte[] buffer = new byte[SQLITE_TEXT.length()];
            is.read(buffer);
            is.reset();
            String actualText = new String(buffer);
            ProjectFile result = SQLITE_TEXT.equals(actualText) ? this.readDatabaseFile(is) : this.readTextFile(is);
            return result;
        }
        catch (IOException ex) {
            throw new MPXJException("Failed to read file", ex);
        }
    }

    private void addListeners(ProjectReader reader) {
        if (this.m_projectListeners != null) {
            for (ProjectListener listener : this.m_projectListeners) {
                reader.addProjectListener(listener);
            }
        }
    }

    private ProjectFile readTextFile(InputStream inputStream) throws MPXJException {
        AstaTextFileReader reader = new AstaTextFileReader();
        this.addListeners(reader);
        return reader.read(inputStream);
    }

    private ProjectFile readDatabaseFile(InputStream inputStream) throws MPXJException {
        AstaDatabaseFileReader reader = new AstaDatabaseFileReader();
        this.addListeners(reader);
        return reader.read(inputStream);
    }
}

