/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import net.sf.mpxj.MpxjEnum;
import net.sf.mpxj.common.EnumHelper;
import net.sf.mpxj.common.NumberHelper;

public enum WorkContour implements MpxjEnum
{
    FLAT(0),
    BACK_LOADED(1),
    FRONT_LOADED(2),
    DOUBLE_PEAK(3),
    EARLY_PEAK(4),
    LATE_PEAK(5),
    BELL(6),
    TURTLE(7),
    CONTOURED(8);

    private static final WorkContour[] TYPE_VALUES;
    private int m_value;

    private WorkContour(int type) {
        this.m_value = type;
    }

    public static WorkContour getInstance(int type) {
        if (type < 0 || type >= TYPE_VALUES.length) {
            type = FLAT.getValue();
        }
        return TYPE_VALUES[type];
    }

    public static WorkContour getInstance(Number type) {
        int value = type == null ? -1 : NumberHelper.getInt(type);
        return WorkContour.getInstance(value);
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    static {
        TYPE_VALUES = (WorkContour[])EnumHelper.createTypeArray(WorkContour.class);
    }
}

