/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Iterator;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectEntityContainer;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;

public class ProjectCalendarContainer
extends ProjectEntityContainer<ProjectCalendar> {
    public ProjectCalendarContainer(ProjectFile projectFile) {
        super(projectFile);
    }

    @Override
    public void removed(ProjectCalendar calendar) {
        Resource resource = calendar.getResource();
        if (resource != null) {
            resource.setResourceCalendar(null);
        }
        calendar.setParent(null);
    }

    public ProjectCalendar add() {
        ProjectCalendar calendar = new ProjectCalendar(this.m_projectFile);
        this.add(calendar);
        return calendar;
    }

    public ProjectCalendar addDefaultBaseCalendar() {
        ProjectCalendar calendar = this.add();
        calendar.setName("Standard");
        calendar.setWorkingDay(Day.SUNDAY, false);
        calendar.setWorkingDay(Day.MONDAY, true);
        calendar.setWorkingDay(Day.TUESDAY, true);
        calendar.setWorkingDay(Day.WEDNESDAY, true);
        calendar.setWorkingDay(Day.THURSDAY, true);
        calendar.setWorkingDay(Day.FRIDAY, true);
        calendar.setWorkingDay(Day.SATURDAY, false);
        calendar.addDefaultCalendarHours();
        return calendar;
    }

    public ProjectCalendar addDefaultDerivedCalendar() {
        ProjectCalendar calendar = this.add();
        calendar.setWorkingDay(Day.SUNDAY, DayType.DEFAULT);
        calendar.setWorkingDay(Day.MONDAY, DayType.DEFAULT);
        calendar.setWorkingDay(Day.TUESDAY, DayType.DEFAULT);
        calendar.setWorkingDay(Day.WEDNESDAY, DayType.DEFAULT);
        calendar.setWorkingDay(Day.THURSDAY, DayType.DEFAULT);
        calendar.setWorkingDay(Day.FRIDAY, DayType.DEFAULT);
        calendar.setWorkingDay(Day.SATURDAY, DayType.DEFAULT);
        return calendar;
    }

    public ProjectCalendar getByName(String calendarName) {
        ProjectCalendar calendar = null;
        if (calendarName != null && calendarName.length() != 0) {
            String name;
            Iterator iter = this.iterator();
            while (iter.hasNext() && ((name = (calendar = (ProjectCalendar)iter.next()).getName()) == null || !name.equalsIgnoreCase(calendarName))) {
                calendar = null;
            }
        }
        return calendar;
    }
}

