/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.ProjectFile;

public final class Column {
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_CENTER = 2;
    public static final int ALIGN_RIGHT = 3;
    private FieldType m_fieldType;
    private int m_width;
    private int m_alignTitle;
    private int m_alignData;
    private String m_title;
    private ProjectFile m_project;

    public Column(ProjectFile project) {
        this.m_project = project;
    }

    public int getAlignData() {
        return this.m_alignData;
    }

    public int getAlignTitle() {
        return this.m_alignTitle;
    }

    public FieldType getFieldType() {
        return this.m_fieldType;
    }

    public String getTitle() {
        return this.getTitle(Locale.getDefault());
    }

    public String getTitle(Locale locale) {
        String result = null;
        if (this.m_title != null) {
            result = this.m_title;
        } else if (this.m_fieldType != null && (result = this.m_project.getCustomFields().getCustomField(this.m_fieldType).getAlias()) == null) {
            result = this.m_fieldType.getName(locale);
        }
        return result;
    }

    public int getWidth() {
        return this.m_width;
    }

    public void setAlignData(int alignment) {
        this.m_alignData = alignment;
    }

    public void setAlignTitle(int alignment) {
        this.m_alignTitle = alignment;
    }

    public void setFieldType(FieldType type) {
        this.m_fieldType = type;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public void setWidth(int width) {
        this.m_width = width;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print("[Column type=");
        pw.print(this.m_fieldType);
        pw.print(" width=");
        pw.print(this.m_width);
        pw.print(" titleAlignment=");
        if (this.m_alignTitle == 1) {
            pw.print("LEFT");
        } else if (this.m_alignTitle == 2) {
            pw.print("CENTER");
        } else {
            pw.print("RIGHT");
        }
        pw.print(" dataAlignment=");
        if (this.m_alignData == 1) {
            pw.print("LEFT");
        } else if (this.m_alignData == 2) {
            pw.print("CENTER");
        } else {
            pw.print("RIGHT");
        }
        pw.print(" title=");
        pw.print(this.getTitle());
        pw.println("]");
        pw.close();
        return sw.toString();
    }
}

